/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.schedule.DateDuration;
import eu.woolplatform.utils.schedule.TimeDuration;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class TaskSchedule {

    public static class UtcTime
    extends TaskSchedule {
        private DateTime time;
        private boolean exact;

        public UtcTime(DateTime time, boolean exact) {
            this.time = time;
            this.exact = exact;
        }

        public DateTime getTime() {
            return this.time;
        }

        public boolean isExact() {
            return this.exact;
        }
    }

    public static class LocalTime
    extends TaskSchedule {
        private LocalDateTime time;
        private boolean exact;

        public LocalTime(LocalDateTime time, boolean exact) {
            this.time = time;
            this.exact = exact;
        }

        public LocalDateTime getTime() {
            return this.time;
        }

        public boolean isExact() {
            return this.exact;
        }
    }

    public static class TimeSchedule
    extends TaskSchedule {
        private LocalDate startDate;
        private org.joda.time.LocalTime startTime;
        private LocalDate endDate = null;
        private org.joda.time.LocalTime endTime = null;
        private DateDuration repeatDate = null;
        private TimeDuration repeatTime = null;

        public TimeSchedule(LocalDate startDate, org.joda.time.LocalTime startTime) {
            this.startDate = startDate;
            this.startTime = startTime;
        }

        public LocalDate getStartDate() {
            return this.startDate;
        }

        public void setStartDate(LocalDate startDate) {
            this.startDate = startDate;
        }

        public org.joda.time.LocalTime getStartTime() {
            return this.startTime;
        }

        public void setStartTime(org.joda.time.LocalTime startTime) {
            this.startTime = startTime;
        }

        public LocalDate getEndDate() {
            return this.endDate;
        }

        public void setEndDate(LocalDate endDate) {
            this.endDate = endDate;
        }

        public org.joda.time.LocalTime getEndTime() {
            return this.endTime;
        }

        public void setEndTime(org.joda.time.LocalTime endTime) {
            this.endTime = endTime;
        }

        public DateDuration getRepeatDate() {
            return this.repeatDate;
        }

        public void setRepeatDate(DateDuration repeatDate) {
            this.repeatDate = repeatDate;
        }

        public TimeDuration getRepeatTime() {
            return this.repeatTime;
        }

        public void setRepeatTime(TimeDuration repeatTime) {
            this.repeatTime = repeatTime;
        }
    }

    public static class FixedDelay
    extends TaskSchedule {
        private long delay;

        public FixedDelay(long delay) {
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }
    }

    public static class FixedRate
    extends TaskSchedule {
        private long interval;

        public FixedRate(long interval) {
            this.interval = interval;
        }

        public long getInterval() {
            return this.interval;
        }
    }

    public static class Immediate
    extends TaskSchedule {
    }
}

