/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.AppComponents;
import eu.woolplatform.utils.ReflectionUtils;
import eu.woolplatform.utils.exception.HandledException;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.schedule.DateDuration;
import eu.woolplatform.utils.schedule.DateUnit;
import eu.woolplatform.utils.schedule.ScheduleParams;
import eu.woolplatform.utils.schedule.ScheduledTask;
import eu.woolplatform.utils.schedule.ScheduledTaskSpec;
import eu.woolplatform.utils.schedule.TaskSchedule;
import eu.woolplatform.utils.schedule.TimeDuration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;
import org.joda.time.Years;
import org.slf4j.Logger;

public abstract class TaskScheduler {
    public static final String LOGTAG = TaskScheduler.class.getSimpleName();
    private final Object lock = new Object();
    private Map<String, ScheduledTask> runningTasks = new HashMap<String, ScheduledTask>();
    private Map<String, ScheduledTask> scheduledTasks = new HashMap<String, ScheduledTask>();
    private Map<String, ScheduledTaskSpec> scheduledTaskInstances = new HashMap<String, ScheduledTaskSpec>();
    private Logger logger = AppComponents.getLogger(LOGTAG);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initScheduledTasks(Object context, List<ScheduledTaskSpec> taskSpecs) {
        Object object = this.lock;
        synchronized (object) {
            for (ScheduledTaskSpec taskSpec : taskSpecs) {
                ScheduledTask task;
                this.cancelScheduledTask(context, taskSpec.getId());
                try {
                    task = this.buildTask(context, taskSpec.getClassName(), taskSpec.getId(), taskSpec.getTaskData());
                }
                catch (HandledException ex) {
                    continue;
                }
                this.logger.info("Restore scheduled task " + this.getScheduledTaskSpecLog(taskSpec));
                this.scheduledTasks.put(taskSpec.getId(), task);
                this.scheduledTaskInstances.put(taskSpec.getId(), taskSpec);
                this.scheduleTask(context, taskSpec);
            }
        }
    }

    private String getScheduledTaskSpecLog(ScheduledTaskSpec taskSpec) {
        ScheduleParams scheduleParams = taskSpec.getScheduleParams();
        boolean exact = scheduleParams.isExact();
        String time = scheduleParams.getLocalTime() != null ? scheduleParams.getLocalTime().toString("yyyy-MM-dd'T'HH:mm:ss.SSS") : new DateTime((Object)scheduleParams.getUtcTime()).toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
        return String.format("\"%s\" (%s) scheduled %s at %s", taskSpec.getName(), taskSpec.getId(), exact ? "exactly" : "approximately", time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ScheduledTask> List<T> findTasksWithClass(Class<T> taskClass) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<ScheduledTask> result = new ArrayList<ScheduledTask>();
            LinkedHashMap<String, ScheduledTask> tasks = new LinkedHashMap<String, ScheduledTask>(this.runningTasks);
            tasks.putAll(this.scheduledTasks);
            for (String taskId : tasks.keySet()) {
                ScheduledTask task = (ScheduledTask)tasks.get(taskId);
                if (!taskClass.isInstance(task)) continue;
                result.add((ScheduledTask)taskClass.cast(task));
            }
            return result;
        }
    }

    public String generateTaskId() {
        return UUID.randomUUID().toString().toLowerCase().replaceAll("-", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(Object context, ScheduledTask task, String taskId) {
        Object object = this.lock;
        synchronized (object) {
            task.setId(taskId);
            this.scheduledTasks.put(taskId, task);
            DateTime now = new DateTime();
            TaskSchedule schedule = task.getSchedule();
            if (schedule instanceof TaskSchedule.Immediate) {
                this.startImmediate(context, task, now);
            } else if (schedule instanceof TaskSchedule.FixedDelay) {
                this.startFixedDelay(context, task, now, new ScheduleParams(now.getMillis(), false));
            } else if (schedule instanceof TaskSchedule.FixedRate) {
                this.startFixedRate(context, task, now, new ScheduleParams(now.getMillis(), true));
            } else if (schedule instanceof TaskSchedule.TimeSchedule) {
                this.scheduleTimeSchedule(context, task, now.toLocalDateTime());
            } else if (schedule instanceof TaskSchedule.LocalTime) {
                this.scheduleLocalTime(context, task);
            } else if (schedule instanceof TaskSchedule.UtcTime) {
                this.scheduleUtcTime(context, task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(Object context, String taskId) {
        Object object = this.lock;
        synchronized (object) {
            this.scheduledTaskInstances.remove(taskId);
            this.cancelScheduledTask(context, taskId);
            ScheduledTask task = this.scheduledTasks.remove(taskId);
            if (task != null) {
                this.logger.info(String.format("Cancelled scheduled task \"%s\" (%s)", task.getName(), taskId));
            }
            if ((task = this.runningTasks.remove(taskId)) != null) {
                task.cancel(context);
                this.logger.info(String.format("Cancelled running task \"%s\" (%s)", task.getName(), taskId));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTasksWithClass(Object context, Class<? extends ScheduledTask> taskClass) {
        Object object = this.lock;
        synchronized (object) {
            List<? extends ScheduledTask> tasks = this.findTasksWithClass(taskClass);
            for (ScheduledTask scheduledTask : tasks) {
                this.cancelTask(context, scheduledTask.getId());
            }
        }
    }

    protected abstract void scheduleTask(Object var1, ScheduledTaskSpec var2);

    protected abstract void cancelScheduledTask(Object var1, String var2);

    protected abstract void runOnUiThread(Runnable var1);

    protected abstract boolean canRunTaskOnMainThread();

    private void startImmediate(final Object context, final ScheduledTask task, final DateTime now) {
        if (!this.canRunTaskOnMainThread() || task.isRunOnWorkerThread()) {
            new Thread(){

                @Override
                public void run() {
                    TaskScheduler.this.runImmediate(context, task, now);
                }
            }.start();
        } else {
            this.runImmediate(context, task, now);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImmediate(Object context, ScheduledTask task, DateTime now) {
        String taskId = task.getId();
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.logger.info(String.format("Start immediate task \"%s\" (%s)", task.getName(), taskId));
            this.runningTasks.put(taskId, task);
        }
        ScheduleParams scheduleParams = new ScheduleParams(now.getMillis(), true);
        Throwable exception = null;
        try {
            task.run(context, taskId, now, scheduleParams);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.runningTasks.remove(taskId);
            this.scheduledTasks.remove(taskId);
            if (exception == null) {
                this.logger.info(String.format("Immediate task \"%s\" (%s) completed", task.getName(), taskId));
            } else {
                this.logger.error(String.format("Error in immediate task \"%s\" (%s)", task.getName(), taskId) + ": " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFixedDelay(Object context, ScheduledTask task, DateTime time) {
        Object object = this.lock;
        synchronized (object) {
            String taskId = task.getId();
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.logger.info(String.format("Schedule fixed delay task \"%s\" (%s) at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")));
            ScheduleParams scheduleParams = new ScheduleParams(time.getMillis(), false);
            ScheduledTaskSpec taskSpec = new ScheduledTaskSpec(taskId, task, scheduleParams);
            this.scheduledTaskInstances.put(taskId, taskSpec);
            this.scheduleTask(context, taskSpec);
        }
    }

    private void startFixedDelay(final Object context, final ScheduledTask task, final DateTime now, final ScheduleParams scheduleParams) {
        if (!this.canRunTaskOnMainThread() || task.isRunOnWorkerThread()) {
            new Thread(){

                @Override
                public void run() {
                    TaskScheduler.this.runFixedDelay(context, task, now, scheduleParams);
                }
            }.start();
        } else {
            this.runFixedDelay(context, task, now, scheduleParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFixedDelay(final Object context, final ScheduledTask task, DateTime now, ScheduleParams scheduleParams) {
        String taskId = task.getId();
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            DateTime time = new DateTime((Object)scheduleParams.getUtcTime());
            this.logger.info(String.format("Start fixed delay task \"%s\" (%s) scheduled at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")));
            this.runningTasks.put(taskId, task);
        }
        Throwable exception = null;
        try {
            task.run(context, taskId, now, scheduleParams);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            now = new DateTime();
            this.runningTasks.remove(taskId);
            if (exception == null) {
                this.logger.info(String.format("Fixed delay task \"%s\" (%s) completed", task.getName(), taskId));
            } else {
                this.logger.error(String.format("Error in fixed delay task \"%s\" (%s)", task.getName(), taskId) + ": " + exception.getMessage(), exception);
            }
            TaskSchedule.FixedDelay schedule = (TaskSchedule.FixedDelay)task.getSchedule();
            final long next = now.getMillis() + schedule.getDelay();
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TaskScheduler.this.scheduleFixedDelay(context, task, new DateTime(next));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleFixedRate(Object context, ScheduledTask task, DateTime time) {
        Object object = this.lock;
        synchronized (object) {
            String taskId = task.getId();
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.logger.info(String.format("Schedule fixed rate task \"%s\" (%s) at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")));
            ScheduleParams scheduleParams = new ScheduleParams(time.getMillis(), true);
            ScheduledTaskSpec taskSpec = new ScheduledTaskSpec(taskId, task, scheduleParams);
            this.scheduledTaskInstances.put(taskId, taskSpec);
            this.scheduleTask(context, taskSpec);
        }
    }

    private void startFixedRate(final Object context, final ScheduledTask task, final DateTime now, final ScheduleParams scheduleParams) {
        if (!this.canRunTaskOnMainThread() || task.isRunOnWorkerThread()) {
            new Thread(){

                @Override
                public void run() {
                    TaskScheduler.this.runFixedRate(context, task, now, scheduleParams);
                }
            }.start();
        } else {
            this.runFixedRate(context, task, now, scheduleParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFixedRate(final Object context, final ScheduledTask task, DateTime now, ScheduleParams scheduleParams) {
        String taskId = task.getId();
        DateTime time = new DateTime((Object)scheduleParams.getUtcTime());
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.logger.info(String.format("Start fixed rate task \"%s\" (%s) scheduled at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")));
            this.runningTasks.put(taskId, task);
        }
        Throwable exception = null;
        try {
            task.run(context, taskId, now, scheduleParams);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.runningTasks.remove(taskId);
            if (exception == null) {
                this.logger.info(String.format("Fixed rate task \"%s\" (%s) completed", task.getName(), taskId));
            } else {
                this.logger.error(String.format("Error in fixed rate task \"%s\" (%s)", task.getName(), taskId) + ": " + exception.getMessage(), exception);
            }
            TaskSchedule.FixedRate schedule = (TaskSchedule.FixedRate)task.getSchedule();
            long interval = schedule.getInterval();
            long nowMs = System.currentTimeMillis();
            long timeMs = time.getMillis();
            long iter = (nowMs - timeMs) / interval;
            final long next = timeMs + (iter + 1L) * interval;
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TaskScheduler.this.scheduleFixedRate(context, task, new DateTime(next));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleTimeSchedule(Object context, ScheduledTask task, LocalDateTime start) {
        Object object = this.lock;
        synchronized (object) {
            String taskId = task.getId();
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            TaskSchedule.TimeSchedule schedule = (TaskSchedule.TimeSchedule)task.getSchedule();
            String logStr = String.format("Find next time for time schedule task \"%s\" (%s) at or after %s", task.getName(), taskId, start.toString("yyyy-MM-dd'T'HH:mm:ss.SSS"));
            LocalDateTime taskTime = this.getNextScheduledDateTime(start, schedule);
            if (taskTime == null) {
                this.logger.info(logStr + ": no next time");
                this.scheduledTasks.remove(taskId);
                return;
            }
            this.logger.info(logStr + ": " + taskTime.toString("yyyy-MM-dd'T'HH:mm:ss.SSS"));
            ScheduleParams scheduleParams = new ScheduleParams(taskTime, true);
            ScheduledTaskSpec taskSpec = new ScheduledTaskSpec(taskId, task, scheduleParams);
            this.scheduledTaskInstances.put(taskId, taskSpec);
            this.scheduleTask(context, taskSpec);
        }
    }

    private void startTimeSchedule(final Object context, final ScheduledTask task, final DateTime now, final ScheduleParams scheduleParams) {
        if (!this.canRunTaskOnMainThread() || task.isRunOnWorkerThread()) {
            new Thread(){

                @Override
                public void run() {
                    TaskScheduler.this.runTimeSchedule(context, task, now, scheduleParams);
                }
            }.start();
        } else {
            this.runTimeSchedule(context, task, now, scheduleParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTimeSchedule(final Object context, final ScheduledTask task, DateTime now, ScheduleParams scheduleParams) {
        String taskId = task.getId();
        LocalDateTime time = scheduleParams.getLocalTime();
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.logger.info(String.format("Start time schedule task \"%s\" (%s) scheduled at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSS")));
            this.runningTasks.put(taskId, task);
        }
        Throwable exception = null;
        try {
            task.run(context, taskId, now, scheduleParams);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.runningTasks.remove(taskId);
            if (exception == null) {
                this.logger.info(String.format("Time schedule task \"%s\" (%s) completed", task.getName(), taskId));
            } else {
                this.logger.error(String.format("Error in time schedule task \"%s\" (%s)", task.getName(), taskId) + ": " + exception.getMessage(), exception);
            }
            LocalDateTime start = new LocalDateTime();
            if (!start.isAfter((ReadablePartial)time)) {
                start = time.plusMillis(1);
            }
            final LocalDateTime finalStart = start;
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TaskScheduler.this.scheduleTimeSchedule(context, task, finalStart);
                }
            });
        }
    }

    private LocalDateTime getNextScheduledDateTime(LocalDateTime start, TaskSchedule.TimeSchedule timeSchedule) {
        LocalDate startDate = start.toLocalDate();
        LocalDate nextDate = this.getNextScheduledDate(startDate, timeSchedule);
        if (nextDate == null) {
            return null;
        }
        LocalTime startDayTime = new LocalTime(0, 0, 0);
        LocalTime fromTime = nextDate.isEqual((ReadablePartial)startDate) ? start.toLocalTime() : startDayTime;
        LocalTime nextTime = this.getNextScheduledTime(fromTime, timeSchedule);
        if (nextTime == null) {
            nextDate = this.getNextScheduledDate(startDate.plusDays(1), timeSchedule);
            if (nextDate == null) {
                return null;
            }
            nextTime = this.getNextScheduledTime(startDayTime, timeSchedule);
        }
        return nextDate.toLocalDateTime(nextTime);
    }

    private LocalDate getNextScheduledDate(LocalDate date, TaskSchedule.TimeSchedule timeSchedule) {
        LocalDate nextDate;
        LocalDate startDate = timeSchedule.getStartDate();
        if (!date.isAfter((ReadablePartial)startDate)) {
            return startDate;
        }
        DateDuration repeat = timeSchedule.getRepeatDate();
        if (repeat == null) {
            return null;
        }
        if (repeat.getUnit() == DateUnit.YEAR) {
            int years = Years.yearsBetween((ReadablePartial)timeSchedule.getStartDate(), (ReadablePartial)date.minusDays(1)).getYears() + 1;
            int repeatCount = repeat.getCount();
            int it = (years + repeatCount - 1) / repeatCount;
            nextDate = startDate.plusYears(it * repeatCount);
        } else if (repeat.getUnit() == DateUnit.MONTH) {
            int months = Months.monthsBetween((ReadablePartial)timeSchedule.getStartDate(), (ReadablePartial)date.minusDays(1)).getMonths() + 1;
            int repeatCount = repeat.getCount();
            int it = (months + repeatCount - 1) / repeatCount;
            nextDate = startDate.plusMonths(it * repeatCount);
        } else {
            int days = Days.daysBetween((ReadablePartial)timeSchedule.getStartDate(), (ReadablePartial)date).getDays();
            int repeatCount = repeat.getUnit() == DateUnit.WEEK ? 7 * repeat.getCount() : repeat.getCount();
            int it = (days + repeatCount - 1) / repeatCount;
            nextDate = startDate.plusDays(it * repeatCount);
        }
        LocalDate endDate = timeSchedule.getEndDate();
        if (endDate != null && !nextDate.isBefore((ReadablePartial)endDate)) {
            return null;
        }
        return nextDate;
    }

    private LocalTime getNextScheduledTime(LocalTime time, TaskSchedule.TimeSchedule timeSchedule) {
        LocalTime startTime = timeSchedule.getStartTime();
        if (!time.isAfter((ReadablePartial)startTime)) {
            return startTime;
        }
        TimeDuration repeat = timeSchedule.getRepeatTime();
        if (repeat == null) {
            return null;
        }
        int startMs = startTime.getMillisOfDay();
        int dayEndMs = 86400000;
        int repeatMs = (int)repeat.getDuration();
        int intervalMs = time.getMillisOfDay() - startTime.getMillisOfDay();
        int it = (intervalMs + repeatMs - 1) / repeatMs;
        int nextMs = startMs + it * repeatMs;
        if (nextMs >= dayEndMs) {
            return null;
        }
        LocalTime nextTime = new LocalTime().withMillisOfDay(nextMs);
        LocalTime endTime = timeSchedule.getEndTime();
        if (endTime != null && !nextTime.isBefore((ReadablePartial)endTime)) {
            return null;
        }
        return nextTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleLocalTime(Object context, ScheduledTask task) {
        Object object = this.lock;
        synchronized (object) {
            String taskId = task.getId();
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            TaskSchedule.LocalTime schedule = (TaskSchedule.LocalTime)task.getSchedule();
            LocalDateTime time = schedule.getTime();
            this.logger.info(String.format("Schedule local time task \"%s\" (%s) at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSS")));
            ScheduleParams scheduleParams = new ScheduleParams(time, schedule.isExact());
            ScheduledTaskSpec taskSpec = new ScheduledTaskSpec(taskId, task, scheduleParams);
            this.scheduledTaskInstances.put(taskId, taskSpec);
            this.scheduleTask(context, taskSpec);
        }
    }

    private void startLocalTime(final Object context, final ScheduledTask task, final DateTime now, final ScheduleParams scheduleParams) {
        if (!this.canRunTaskOnMainThread() || task.isRunOnWorkerThread()) {
            new Thread(){

                @Override
                public void run() {
                    TaskScheduler.this.runLocalTime(context, task, now, scheduleParams);
                }
            }.start();
        } else {
            this.runLocalTime(context, task, now, scheduleParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocalTime(Object context, ScheduledTask task, DateTime now, ScheduleParams scheduleParams) {
        String taskId = task.getId();
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            LocalDateTime time = scheduleParams.getLocalTime();
            this.logger.info(String.format("Start local time task \"%s\" (%s) scheduled at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSS")));
            this.runningTasks.put(taskId, task);
        }
        Throwable exception = null;
        try {
            task.run(context, taskId, now, scheduleParams);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.runningTasks.remove(taskId);
            this.scheduledTasks.remove(taskId);
            if (exception == null) {
                this.logger.info(String.format("Local time task \"%s\" (%s) completed", task.getName(), taskId));
            } else {
                this.logger.error(String.format("Error in local time task \"%s\" (%s)", task.getName(), taskId) + ": " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleUtcTime(Object context, ScheduledTask task) {
        Object object = this.lock;
        synchronized (object) {
            String taskId = task.getId();
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            TaskSchedule.UtcTime schedule = (TaskSchedule.UtcTime)task.getSchedule();
            DateTime time = schedule.getTime();
            this.logger.info(String.format("Schedule UTC time task \"%s\" (%s) at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")));
            ScheduleParams scheduleParams = new ScheduleParams(time.getMillis(), schedule.isExact());
            ScheduledTaskSpec taskSpec = new ScheduledTaskSpec(taskId, task, scheduleParams);
            this.scheduledTaskInstances.put(taskId, taskSpec);
            this.scheduleTask(context, taskSpec);
        }
    }

    private void startUtcTime(final Object context, final ScheduledTask task, final DateTime now, final ScheduleParams scheduleParams) {
        if (!this.canRunTaskOnMainThread() || task.isRunOnWorkerThread()) {
            new Thread(){

                @Override
                public void run() {
                    TaskScheduler.this.runUtcTime(context, task, now, scheduleParams);
                }
            }.start();
        } else {
            this.runUtcTime(context, task, now, scheduleParams);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUtcTime(Object context, ScheduledTask task, DateTime now, ScheduleParams scheduleParams) {
        String taskId = task.getId();
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            DateTime time = new DateTime((Object)scheduleParams.getUtcTime());
            this.logger.info(String.format("Start UTC time task \"%s\" (%s) scheduled at %s", task.getName(), taskId, time.toString("yyyy-MM-dd'T'HH:mm:ss.SSSZZ")));
            this.runningTasks.put(taskId, task);
        }
        Throwable exception = null;
        try {
            task.run(context, taskId, now, scheduleParams);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.scheduledTasks.containsKey(taskId)) {
                return;
            }
            this.runningTasks.remove(taskId);
            this.scheduledTasks.remove(taskId);
            if (exception == null) {
                this.logger.info(String.format("UTC time task \"%s\" (%s) completed", task.getName(), taskId));
            } else {
                this.logger.error(String.format("Error in UTC time task \"%s\" (%s)", task.getName(), taskId) + ": " + exception.getMessage(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTriggerTask(Object context, ScheduledTaskSpec taskSpec) {
        Object object = this.lock;
        synchronized (object) {
            DateTime now = new DateTime();
            String taskId = taskSpec.getId();
            ScheduledTaskSpec scheduledSpec = this.scheduledTaskInstances.get(taskId);
            if (scheduledSpec == null || !scheduledSpec.equals(taskSpec)) {
                this.logger.info(String.format("Scheduled task %s not found on trigger", this.getScheduledTaskSpecLog(taskSpec)));
                return;
            }
            this.logger.info("Start triggered task " + this.getScheduledTaskSpecLog(taskSpec));
            this.scheduledTaskInstances.remove(taskId);
            ScheduledTask task = this.scheduledTasks.get(taskId);
            TaskSchedule schedule = task.getSchedule();
            if (schedule instanceof TaskSchedule.FixedDelay) {
                this.startFixedDelay(context, task, now, taskSpec.getScheduleParams());
            } else if (schedule instanceof TaskSchedule.FixedRate) {
                this.startFixedRate(context, task, now, taskSpec.getScheduleParams());
            } else if (schedule instanceof TaskSchedule.TimeSchedule) {
                this.startTimeSchedule(context, task, now, taskSpec.getScheduleParams());
            } else if (schedule instanceof TaskSchedule.LocalTime) {
                this.startLocalTime(context, task, now, taskSpec.getScheduleParams());
            } else if (schedule instanceof TaskSchedule.UtcTime) {
                this.startUtcTime(context, task, now, taskSpec.getScheduleParams());
            }
        }
    }

    private ScheduledTask buildTask(Object context, String className, String taskId, String taskData) throws HandledException {
        Class<ScheduledTask> taskClass;
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            this.logger.error("ScheduledTask class " + className + " not found: " + ex.getMessage());
            throw new HandledException();
        }
        try {
            taskClass = clazz.asSubclass(ScheduledTask.class);
        }
        catch (ClassCastException ex) {
            this.logger.error("Class " + className + " is not a ScheduledTask: " + ex.getMessage());
            throw new HandledException();
        }
        ScheduledTask task = null;
        if (context != null) {
            try {
                task = ReflectionUtils.newInstance(taskClass, context);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        if (task == null) {
            try {
                task = ReflectionUtils.newInstance(taskClass, new Object[0]);
            }
            catch (InstantiationException ex) {
                this.logger.error("Can't construct instance of " + className + ": " + ex.getMessage());
                throw new HandledException();
            }
            catch (InvocationTargetException ex) {
                this.logger.error("Exception in constructor of class " + className + ": " + ex.getCause().getMessage());
                throw new HandledException();
            }
        }
        task.setId(taskId);
        try {
            task.setTaskData(taskData);
        }
        catch (ParseException ex) {
            this.logger.error("Can't parse task data for task class " + className + "\": " + ex.getMessage());
            throw new HandledException();
        }
        return task;
    }
}

