/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.schedule.TimeUnit;

public class TimeDuration {
    private int count;
    private TimeUnit unit;

    public TimeDuration(int count, TimeUnit unit) {
        this.count = count;
        this.unit = unit;
    }

    public int getCount() {
        return this.count;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public long getDuration() {
        return this.unit.getDuration(this.count);
    }

    public int hashCode() {
        return this.count;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TimeDuration)) {
            return false;
        }
        TimeDuration cmp = (TimeDuration)obj;
        if (this.count != cmp.count) {
            return false;
        }
        return this.unit == cmp.unit;
    }

    public String toString() {
        return this.unit.getDurationString(this.count);
    }

    public static TimeDuration parse(String s, TimeUnit min, TimeUnit max) throws ParseException {
        TimeUnit unit;
        int count;
        String trimmed = s.trim();
        if (trimmed.length() == 0) {
            throw new ParseException("Invalid time duration: " + s);
        }
        String[] split = trimmed.split("\\s+");
        if (split.length != 2) {
            throw new ParseException("Invalid time duration: " + s);
        }
        try {
            count = Integer.parseInt(split[0]);
            unit = TimeUnit.parse(split[1], min, max);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Invalid time duration: " + s, ex);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Invalid time duration: " + s, ex);
        }
        if (count < 0) {
            throw new ParseException("Invalid time duration: " + s);
        }
        return new TimeDuration(count, unit);
    }
}

