/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import java.util.ArrayList;
import java.util.List;

public class TimeUnit {
    public static final TimeUnit HOUR = new TimeUnit(3600000, "hour", "hours");
    public static final TimeUnit MINUTE = new TimeUnit(60000, "minute", "minutes");
    public static final TimeUnit SECOND = new TimeUnit(1000, "second", "seconds");
    public static final TimeUnit MILLISECOND = new TimeUnit(1, "millisecond", "milliseconds");
    private static List<TimeUnit> timeUnits = null;
    private static final Object lock = new Object();
    private int ms;
    private String singular;
    private String plural;

    private TimeUnit(int ms, String singular, String plural) {
        this.ms = ms;
        this.singular = singular;
        this.plural = plural;
    }

    public String getDurationString(int n) {
        if (n == 1) {
            return n + " " + this.singular;
        }
        return n + " " + this.plural;
    }

    public long getDuration(int n) {
        return (long)n * (long)this.ms;
    }

    public static TimeUnit parse(String s, TimeUnit min, TimeUnit max) throws IllegalArgumentException {
        TimeUnit[] units;
        String lower = s.toLowerCase();
        for (TimeUnit tu : units = TimeUnit.getTimeUnits(min, max)) {
            if (!lower.equals(tu.singular) && !lower.equals(tu.plural)) continue;
            return tu;
        }
        throw new IllegalArgumentException("Invalid time unit: " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeUnit[] getTimeUnits(TimeUnit min, TimeUnit max) {
        Object object = lock;
        synchronized (object) {
            if (timeUnits == null) {
                timeUnits = new ArrayList<TimeUnit>();
                timeUnits.add(MILLISECOND);
                timeUnits.add(SECOND);
                timeUnits.add(MINUTE);
                timeUnits.add(HOUR);
            }
        }
        if (min == null) {
            min = MILLISECOND;
        }
        if (max == null) {
            max = HOUR;
        }
        int minIndex = timeUnits.indexOf(min);
        int maxIndex = timeUnits.indexOf(max);
        TimeUnit[] result = new TimeUnit[maxIndex - minIndex + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = timeUnits.get(i + minIndex);
        }
        return result;
    }

    public String toString() {
        return this.singular;
    }
}

