/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.schedule;

import eu.woolplatform.utils.AppComponents;
import eu.woolplatform.utils.schedule.Job;
import org.slf4j.Logger;

public class WaitJobRunner {
    private Job waitJob;
    private String logtag;
    private long waitLogDelay;
    private String waitLogMsg;
    private long timeoutDelay;
    private String timeoutLogMsg;
    private boolean finished = false;
    private boolean cancelled = false;
    private final Object lock = new Object();

    public WaitJobRunner(Job waitJob, String logtag, long waitLogDelay, String waitLogMsg, long timeoutDelay, String timeoutLogMsg) {
        this.waitJob = waitJob;
        this.logtag = logtag;
        this.waitLogDelay = waitLogDelay;
        this.waitLogMsg = waitLogMsg;
        this.timeoutDelay = timeoutDelay;
        this.timeoutLogMsg = timeoutLogMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            this.cancelled = true;
            this.lock.notifyAll();
        }
        this.waitJob.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run() {
        long start = System.currentTimeMillis();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                WaitJobRunner.this.waitJob.run();
                Object object = WaitJobRunner.this.lock;
                synchronized (object) {
                    WaitJobRunner.this.finished = true;
                    WaitJobRunner.this.lock.notifyAll();
                }
            }
        }.start();
        Logger logger = AppComponents.getLogger(this.logtag);
        Object object = this.lock;
        synchronized (object) {
            long now;
            long end;
            if (this.waitLogDelay < this.timeoutDelay) {
                end = start + this.waitLogDelay;
                now = start;
                while (!this.finished && !this.cancelled && now < end) {
                    try {
                        this.lock.wait(end - now);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex.getMessage(), ex);
                    }
                    now = System.currentTimeMillis();
                }
                if (this.cancelled) {
                    return false;
                }
                if (this.finished) {
                    return true;
                }
                logger.info(this.waitLogMsg);
            }
            end = start + this.timeoutDelay;
            now = System.currentTimeMillis();
            while (!this.finished && !this.cancelled && now < end) {
                try {
                    this.lock.wait(end - now);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex.getMessage(), ex);
                }
                now = System.currentTimeMillis();
            }
            if (this.cancelled) {
                return false;
            }
            if (this.finished) {
                return true;
            }
            logger.info(this.timeoutLogMsg);
            return false;
        }
    }
}

