/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.validation;

import com.fasterxml.jackson.core.type.TypeReference;
import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.validation.TypeConversion;
import eu.woolplatform.utils.validation.Validation;
import eu.woolplatform.utils.validation.ValidationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class MapReader {
    private Map<?, ?> map;

    public MapReader(Map<?, ?> map) {
        this.map = map;
    }

    public Object readObject(String key) throws ParseException {
        Object obj = this.map.get(key);
        if (obj == null) {
            throw new ParseException(String.format("Key \"%s\" not defined", key));
        }
        return obj;
    }

    public Object readObject(String key, Object defaultVal) {
        Object obj = this.map.get(key);
        return obj == null ? defaultVal : obj;
    }

    public String readString(String key) throws ParseException {
        return TypeConversion.getString(this.readObject(key));
    }

    public String readString(String key, String defaultVal) {
        return TypeConversion.getString(this.readObject(key, defaultVal));
    }

    public String readStringLength(String key, int minLen, int maxLen) throws ParseException {
        try {
            return Validation.validateStringLength(this.readString(key), minLen, maxLen);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public String readStringLength(String key, int minLen, int maxLen, String defaultVal) throws ParseException {
        String s = this.readString(key, defaultVal);
        if (s == null) {
            return null;
        }
        try {
            return Validation.validateStringLength(s, minLen, maxLen);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public String readStringRegex(String key, String regex) throws ParseException {
        try {
            return Validation.validateStringRegex(this.readString(key), regex);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public String readStringRegex(String key, String regex, String defaultVal) throws ParseException {
        String s = this.readString(key, defaultVal);
        if (s == null) {
            return null;
        }
        try {
            return Validation.validateStringRegex(s, regex);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public <T> T readEnum(String key, Class<T> enumClass) throws ParseException {
        String val = this.readString(key);
        try {
            Method method = enumClass.getMethod("valueOf", String.class);
            Object result = method.invoke(null, val);
            return enumClass.cast(result);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException method) {
        }
        catch (InvocationTargetException method) {
            // empty catch block
        }
        try {
            Method method = enumClass.getMethod("fromStringValue", String.class);
            Object result = method.invoke(null, val);
            return enumClass.cast(result);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        throw new ParseException("Invalid value for enum type " + enumClass.getName() + ": " + val);
    }

    public int readInt(String key) throws ParseException {
        return TypeConversion.getInt(this.readObject(key));
    }

    public Integer readInt(String key, Integer defaultVal) throws ParseException {
        Object obj = this.readObject(key, defaultVal);
        if (obj == null) {
            return null;
        }
        return TypeConversion.getInt(obj);
    }

    public int readIntRange(String key, Integer min, Integer max) throws ParseException {
        try {
            return Validation.validateIntRange(this.readInt(key), min, max);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public Integer readIntRange(String key, Integer min, Integer max, Integer defaultVal) throws ParseException {
        Integer n = this.readInt(key, defaultVal);
        if (n == null) {
            return null;
        }
        try {
            return Validation.validateIntRange(n, min, max);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public long readLong(String key) throws ParseException {
        return TypeConversion.getLong(this.readObject(key));
    }

    public Long readLong(String key, Long defaultVal) throws ParseException {
        Object obj = this.readObject(key, defaultVal);
        if (obj == null) {
            return null;
        }
        return TypeConversion.getLong(obj);
    }

    public long readLongRange(String key, Long min, Long max) throws ParseException {
        try {
            return Validation.validateLongRange(this.readLong(key), min, max);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public Long readLongRange(String key, Long min, Long max, Long defaultVal) throws ParseException {
        Long n = this.readLong(key, defaultVal);
        if (n == null) {
            return null;
        }
        try {
            return Validation.validateLongRange(n, min, max);
        }
        catch (ValidationException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public double readDouble(String key) throws ParseException {
        return TypeConversion.getDouble(this.readObject(key));
    }

    public Double readDouble(String key, Double defaultVal) throws ParseException {
        Object obj = this.readObject(key, defaultVal);
        if (obj == null) {
            return null;
        }
        return TypeConversion.getDouble(obj);
    }

    public boolean readBoolean(String key) throws ParseException {
        return TypeConversion.getBoolean(this.readObject(key));
    }

    public Boolean readBoolean(String key, Boolean defaultVal) throws ParseException {
        Object obj = this.readObject(key, defaultVal);
        if (obj == null) {
            return null;
        }
        return TypeConversion.getBoolean(obj);
    }

    public <T> T readJson(String key, Class<T> clazz) throws ParseException {
        return TypeConversion.getJson(this.readObject(key), clazz);
    }

    public <T> T readJson(String key, Class<T> clazz, T defaultVal) throws ParseException {
        return TypeConversion.getJson(this.readObject(key, defaultVal), clazz);
    }

    public <T> T readJson(String key, TypeReference<T> typeRef) throws ParseException {
        return TypeConversion.getJson(this.readObject(key), typeRef);
    }

    public <T> T readJson(String key, TypeReference<T> typeRef, T defaultVal) throws ParseException {
        return TypeConversion.getJson(this.readObject(key, defaultVal), typeRef);
    }
}

