/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.validation;

import eu.woolplatform.utils.beans.PropertyReader;
import eu.woolplatform.utils.validation.TypeConversion;
import eu.woolplatform.utils.validation.ValidateEmail;
import eu.woolplatform.utils.validation.ValidateNotNull;
import eu.woolplatform.utils.validation.ValidateRegex;
import eu.woolplatform.utils.validation.ValidateTimeZone;
import eu.woolplatform.utils.validation.Validation;
import eu.woolplatform.utils.validation.ValidationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ObjectValidation {
    public static Map<String, List<String>> validate(Object obj) {
        LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        List<Field> fields = ObjectValidation.getObjectFields(obj.getClass());
        for (Field field : fields) {
            Annotation[] annots;
            ArrayList<String> errors = new ArrayList<String>();
            for (Annotation annot : annots = field.getAnnotations()) {
                try {
                    ObjectValidation.validateConstraint(obj, field, annot);
                }
                catch (ValidationException ex) {
                    errors.add(ex.getMessage());
                }
            }
            if (errors.isEmpty()) continue;
            result.put(field.getName(), errors);
        }
        return result;
    }

    private static List<Field> getObjectFields(Class<?> clazz) {
        Class<?> superClass = clazz.getSuperclass();
        List<Field> result = superClass != null ? ObjectValidation.getObjectFields(superClass) : new ArrayList<Field>();
        Field[] fields = clazz.getDeclaredFields();
        Collections.addAll(result, fields);
        return result;
    }

    public static String getErrorMessage(Map<String, List<String>> validationResult) {
        if (validationResult.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String newline = System.getProperty("line.separator");
        for (String prop : validationResult.keySet()) {
            List<String> errors = validationResult.get(prop);
            for (String error : errors) {
                if (result.length() > 0) {
                    result.append(newline);
                }
                result.append(String.format("Invalid value for property \"%s\": %s", prop, error));
            }
        }
        return result.toString();
    }

    private static void validateConstraint(Object obj, Field field, Annotation annot) throws ValidationException {
        Object val;
        if (annot.annotationType() == ValidateEmail.class) {
            Object val2 = PropertyReader.readProperty(obj, field.getName());
            if (val2 != null) {
                Validation.validateEmail(TypeConversion.getString(val2));
            }
        } else if (annot.annotationType() == ValidateNotNull.class) {
            Object val3 = PropertyReader.readProperty(obj, field.getName());
            Validation.validateNotNull(val3);
        } else if (annot.annotationType() == ValidateRegex.class) {
            ValidateRegex regexAnnot = (ValidateRegex)annot;
            Object val4 = PropertyReader.readProperty(obj, field.getName());
            if (val4 != null) {
                Validation.validateStringRegex(TypeConversion.getString(val4), regexAnnot.value());
            }
        } else if (annot.annotationType() == ValidateTimeZone.class && (val = PropertyReader.readProperty(obj, field.getName())) != null) {
            Validation.validateTimeZone(TypeConversion.getString(val));
        }
    }
}

