/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.validation;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.woolplatform.utils.exception.ParseException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TypeConversion {
    public static String getString(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static Integer getInt(Object obj) throws ParseException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        String s = obj.toString();
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(String.format("Invalid integer: %s", s));
        }
    }

    public static Long getLong(Object obj) throws ParseException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        String s = obj.toString();
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(String.format("Invalid long: %s", s));
        }
    }

    public static Double getDouble(Object obj) throws ParseException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        String s = obj.toString();
        try {
            return Double.valueOf(s);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(String.format("Invalid double: %s", s));
        }
    }

    public static Boolean getBoolean(Object obj) throws ParseException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        String s = obj.toString();
        String lower = s.toLowerCase();
        if (lower.equals("true") || lower.equals("1")) {
            return true;
        }
        if (lower.equals("false") || lower.equals("0")) {
            return false;
        }
        throw new ParseException(String.format("Invalid boolean: %s", s));
    }

    public static <T extends Enum<?>> T getEnum(Object obj, Class<T> enumClass) throws ParseException {
        Object array;
        if (obj == null) {
            return null;
        }
        if (enumClass.isInstance(obj)) {
            return (T)((Enum)enumClass.cast(obj));
        }
        String findLower = obj.toString().toLowerCase();
        try {
            Method method = enumClass.getMethod("values", new Class[0]);
            array = method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object candidate = Array.get(array, i);
            if (!candidate.toString().toLowerCase().equals(findLower)) continue;
            return (T)((Enum)enumClass.cast(candidate));
        }
        throw new ParseException("Unknown value " + obj + " for enum class " + enumClass.getName());
    }

    public static <T> T getJson(Object obj, Class<T> clazz) throws ParseException {
        if (obj == null) {
            return null;
        }
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.convertValue(obj, clazz);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Invalid JSON content: " + ex.getMessage(), ex);
        }
    }

    public static <T> T getJson(Object obj, TypeReference<T> typeRef) throws ParseException {
        if (obj == null) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.convertValue(obj, typeRef);
        }
        catch (IllegalArgumentException ex) {
            throw new ParseException("Invalid JSON content: " + ex.getMessage(), ex);
        }
    }
}

