/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.validation;

import eu.woolplatform.utils.validation.ValidationException;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class Validation {
    public static String validateStringLength(String s, int minLen, int maxLen) throws ValidationException {
        if (minLen <= 0 && maxLen <= 0) {
            return s;
        }
        String error = minLen > 0 && maxLen > 0 ? String.format("String length not between %d and %d: %s", minLen, maxLen, s) : (minLen > 0 ? String.format("String length less than %d: %s", minLen, s) : String.format("String length greater than %d: %s", maxLen, s));
        if (s.length() < minLen || maxLen > 0 && s.length() > maxLen) {
            throw new ValidationException(error);
        }
        return s;
    }

    public static String validateStringRegex(String s, String regex) throws ValidationException {
        if (!s.matches(regex)) {
            throw new ValidationException(String.format("String does not match regular expression %s: %s", regex, s));
        }
        return s;
    }

    public static int validateIntRange(int n, Integer min, Integer max) throws ValidationException {
        if (min == null && max == null) {
            return n;
        }
        String error = min != null && max != null ? String.format("Integer not between %d and %d: %d", min, max, n) : (min != null ? String.format("Integer less than %d: %d", min, n) : String.format("Integer greater than %d: %d", max, n));
        if (min != null && n < min || max != null && n > max) {
            throw new ValidationException(error);
        }
        return n;
    }

    public static long validateLongRange(long n, Long min, Long max) throws ValidationException {
        if (min == null && max == null) {
            return n;
        }
        String error = min != null && max != null ? String.format("Long not between %d and %d: %d", min, max, n) : (min != null ? String.format("Long less than %d: %d", min, n) : String.format("Long greater than %d: %d", max, n));
        if (min != null && n < min || max != null && n > max) {
            throw new ValidationException(error);
        }
        return n;
    }

    public static String validateEmail(String email) throws ValidationException {
        if (email.length() == 0) {
            throw new ValidationException("Empty value");
        }
        int localDomainSep = email.lastIndexOf(64);
        if (localDomainSep == -1) {
            throw new ValidationException("Character '@' not found");
        }
        String localPart = email.substring(0, localDomainSep);
        String domainPart = email.substring(localDomainSep + 1);
        String allowedLocalChars = "[A-Za-z0-9!#$%&'*+\\-/=?^_`.{|}~]+";
        if (!localPart.matches(allowedLocalChars)) {
            throw new ValidationException("Invalid local part");
        }
        String[] split = domainPart.split("\\.");
        if (split.length < 2) {
            throw new ValidationException("Domain part does not consist of two or more labels");
        }
        for (int i = 0; i < split.length; ++i) {
            String domainLabel = split[i];
            if (!domainLabel.matches("[A-Za-z0-9\\-]+") || domainLabel.startsWith("-") || domainLabel.endsWith("-")) {
                throw new ValidationException("Invalid domain label: " + domainLabel);
            }
            if (i != split.length - 1 || !domainLabel.matches("[0-9]+")) continue;
            throw new ValidationException("Invalid TLD: " + domainLabel);
        }
        return email;
    }

    public static LocalDate validateDate(String dateStr) throws ValidationException {
        if (dateStr.isEmpty()) {
            throw new ValidationException("Empty value");
        }
        DateTimeFormatter parser = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
        try {
            return parser.parseLocalDate(dateStr);
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException("Invalid date: " + dateStr);
        }
    }

    public static String validateTimeZone(String timeZone) throws ValidationException {
        try {
            DateTimeZone.forID((String)timeZone);
            return timeZone;
        }
        catch (IllegalArgumentException ex) {
            throw new ValidationException("Invalid time zone: " + timeZone);
        }
    }

    public static Object validateNotNull(Object obj) throws ValidationException {
        if (obj == null) {
            throw new ValidationException("Value is null");
        }
        return obj;
    }
}

