/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.SimpleSAXHandler;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.xml.sax.Attributes;

public abstract class AbstractSimpleSAXHandler<T>
implements SimpleSAXHandler<T> {
    protected String readAttribute(Attributes atts, String name) throws ParseException {
        String s = atts.getValue(name);
        if (s == null) {
            throw new ParseException("Attribute \"" + name + "\" not found");
        }
        return s;
    }

    protected String readAttribute(Attributes atts, String name, Integer minLength, Integer maxLength) throws ParseException {
        String s = this.readAttribute(atts, name);
        if (minLength == null && maxLength == null) {
            return s;
        }
        String lengthError = minLength != null && maxLength != null ? String.format("Value of attribute \"%s\" must be between %s and %s characters", name, minLength, maxLength) : (minLength != null ? String.format("Value of attribute \"%s\" must be at least %s characters", name, minLength) : String.format("Value of attribute \"%s\" must be at most %s characters", name, maxLength));
        if (minLength != null && s.length() < minLength) {
            throw new ParseException(lengthError);
        }
        if (maxLength != null && s.length() > maxLength) {
            throw new ParseException(lengthError);
        }
        return s;
    }

    protected int readIntAttribute(Attributes atts, String name) throws ParseException {
        String s = this.readAttribute(atts, name);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Invalid value of attribute \"" + name + "\": " + s, ex);
        }
    }

    protected float readFloatAttribute(Attributes atts, String name) throws ParseException {
        String s = this.readAttribute(atts, name);
        try {
            return Float.parseFloat(s);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Invalid value of attribute \"" + name + "\": " + s, ex);
        }
    }

    protected boolean readBooleanAttribute(Attributes atts, String name) throws ParseException {
        String s = this.readAttribute(atts, name);
        switch (s.toLowerCase()) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new ParseException("Invalid value of attribute \"" + name + "\": " + s);
    }

    protected <U extends Enum<U>> U readEnumAttribute(Class<U> clazz, Attributes atts, String name) throws ParseException {
        Object[] array;
        String s = this.readAttribute(atts, name);
        try {
            Method method = clazz.getMethod("values", new Class[0]);
            array = (Object[])method.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new ParseException("Can't get enum values: " + ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new ParseException("Can't get enum values: " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new ParseException("Can't get enum values: " + ex.getMessage(), ex);
        }
        for (Object item : array) {
            if (!item.toString().toLowerCase().equals(s.toLowerCase())) continue;
            return (U)((Enum)clazz.cast(item));
        }
        throw new ParseException("Invalid value of attribute \"" + name + "\": " + s);
    }

    protected File readFileAttribute(Attributes atts, String name) throws ParseException {
        return this.readFileAttribute(atts, name, null);
    }

    protected File readFileAttribute(Attributes atts, String name, File parent) throws ParseException {
        File absPath;
        String s = this.readAttribute(atts, name);
        File path = new File(s);
        if (!path.isAbsolute() && parent != null) {
            path = new File(parent, s);
        }
        try {
            absPath = path.getCanonicalFile();
        }
        catch (Exception ex) {
            absPath = path.getAbsoluteFile();
            System.err.println("WARNING: Can't get canonical path for file: " + absPath.getAbsolutePath());
        }
        return absPath;
    }

    protected String readRegexAttribute(Attributes atts, String name, String regex) throws ParseException {
        String s = this.readAttribute(atts, name);
        if (!s.matches(regex)) {
            throw new ParseException("Invalid value of attribute \"" + name + "\": " + s);
        }
        return s;
    }
}

