/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.XMLValueParser;

public class DoubleValueParser
implements XMLValueParser<Double> {
    private Double minVal;
    private Double maxVal;

    public DoubleValueParser() {
    }

    public DoubleValueParser(Double minVal, Double maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    @Override
    public Double parse(String xml) throws ParseException {
        double val;
        try {
            val = Double.parseDouble(xml);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Value is not a double: \"" + xml + "\"", ex);
        }
        if (this.minVal != null && val < this.minVal || this.maxVal != null && val > this.maxVal) {
            String error = "Double value must be ";
            error = this.maxVal == null ? error + "at least " + this.minVal : (this.minVal == null ? error + "at most " + this.maxVal : error + "between " + this.minVal + " and " + this.maxVal);
            error = error + ": " + val;
            throw new ParseException(error);
        }
        return val;
    }
}

