/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.XMLValueParser;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class EnumValueParser<T extends Enum<T>>
implements XMLValueParser<T> {
    private Class<T> enumClass;

    public EnumValueParser(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public T parse(String xml) throws ParseException {
        Object array;
        String lowerXml = xml.toLowerCase();
        String invokeError = "Can't invoke method values() on enum class";
        try {
            Method method = this.enumClass.getMethod("values", new Class[0]);
            array = method.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx == null) {
                targetEx = ex;
            }
            throw new RuntimeException(invokeError + ": " + targetEx.getMessage(), targetEx);
        }
        catch (Exception ex) {
            throw new RuntimeException(invokeError + ": " + ex.getMessage(), ex);
        }
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object objItem = Array.get(array, i);
            if (!objItem.toString().toLowerCase().equals(lowerXml)) continue;
            return (T)((Enum)this.enumClass.cast(objItem));
        }
        throw new ParseException("Value of enum class " + this.enumClass.getName() + " not found: " + xml);
    }
}

