/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.XMLValueParser;

public class IntValueParser
implements XMLValueParser<Integer> {
    private Integer minVal = null;
    private Integer maxVal = null;

    public IntValueParser() {
    }

    public IntValueParser(Integer minVal, Integer maxVal) {
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    @Override
    public Integer parse(String xml) throws ParseException {
        int val;
        try {
            val = Integer.parseInt(xml);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Value is not an integer: \"" + xml + "\"", ex);
        }
        if (this.minVal != null && val < this.minVal || this.maxVal != null && val > this.maxVal) {
            String error = "Integer value must be ";
            error = this.maxVal == null ? error + "at least " + this.minVal : (this.minVal == null ? error + "at most " + this.maxVal : error + "between " + this.minVal + " and " + this.maxVal);
            error = error + ": " + val;
            throw new ParseException(error);
        }
        return val;
    }
}

