/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.SimpleSAXHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleSAXParser<T> {
    private SimpleSAXHandler<? extends T> simpleHandler;

    public SimpleSAXParser(SimpleSAXHandler<? extends T> handler) {
        this.simpleHandler = handler;
    }

    public T parse(String xml) throws ParseException, IOException {
        InputSource input = new InputSource(new StringReader(xml));
        return this.parse(input);
    }

    public T parse(File f) throws ParseException, IOException {
        try (FileInputStream in = new FileInputStream(f);){
            T t = this.parse(new InputSource(in));
            return t;
        }
    }

    public T parse(InputSource input) throws ParseException, IOException {
        SAXParser parser;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException ex) {
            throw new ParseException("Can't configure SAX parser: " + ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            throw new ParseException("Can't create SAX parser: " + ex.getMessage(), ex);
        }
        SAXHandler handler = new SAXHandler();
        try {
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (SAXParseException ex) {
            throw new ParseException(String.format("Parse error at line %s column %s", ex.getLineNumber(), ex.getColumnNumber()) + ": " + ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            throw new ParseException("Parse error: " + ex.getMessage(), ex);
        }
        return this.simpleHandler.getObject();
    }

    private class SAXHandler
    extends DefaultHandler {
        private List<String> elemStack = new ArrayList<String>();
        private StringBuffer charBuf = new StringBuffer();
        private Locator locator = null;

        private SAXHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charBuf.append(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.charBuf.append(ch, start, length);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String name = qName;
            if (name == null || name.length() == 0) {
                name = localName;
            }
            try {
                if (this.charBuf.length() > 0) {
                    SimpleSAXParser.this.simpleHandler.characters(this.charBuf.toString(), this.elemStack);
                    this.charBuf.setLength(0);
                }
                SimpleSAXParser.this.simpleHandler.startElement(name, attributes, this.elemStack);
                this.elemStack.add(name);
            }
            catch (ParseException ex) {
                throw new SAXParseException(ex.getMessage(), this.locator, ex);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String name = qName;
            if (name == null || name.length() == 0) {
                name = localName;
            }
            try {
                if (this.charBuf.length() > 0) {
                    SimpleSAXParser.this.simpleHandler.characters(this.charBuf.toString(), this.elemStack);
                    this.charBuf.setLength(0);
                }
                this.elemStack.remove(this.elemStack.size() - 1);
                SimpleSAXParser.this.simpleHandler.endElement(name, this.elemStack);
            }
            catch (ParseException ex) {
                throw new SAXParseException(ex.getMessage(), this.locator, ex);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw e;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }
    }
}

