/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.XMLValueParser;

public class StringValueParser
implements XMLValueParser<String> {
    private int minLen = 0;
    private int maxLen = -1;

    public StringValueParser() {
    }

    public StringValueParser(int minLen, int maxLen) {
        this.minLen = minLen;
        this.maxLen = maxLen;
    }

    @Override
    public String parse(String xml) throws ParseException {
        if (xml.length() < this.minLen || this.maxLen >= 0 && xml.length() > this.maxLen) {
            String error = "String length must be ";
            error = this.maxLen < 0 ? error + "at least " + this.minLen : (this.minLen <= 0 ? error + "at most " + this.maxLen : error + "between " + this.minLen + " and " + this.maxLen);
            error = error + ": \"" + xml + "\"";
            throw new ParseException(error);
        }
        return xml;
    }
}

