/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.xml.XMLValueParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLDocumentParser {
    public <T> T parseElemValue(Element parent, String name, XMLValueParser<T> parser, T defaultVal) throws ParseException {
        Element child = this.getChild(parent, name);
        if (child == null) {
            return defaultVal;
        }
        String content = this.parseStringContent(child);
        return parser.parse(content);
    }

    public <T> T parseAttrValue(Element elem, String name, XMLValueParser<T> parser, T defaultVal) throws ParseException {
        Attr attr = elem.getAttributeNode(name);
        if (attr == null) {
            return defaultVal;
        }
        return parser.parse(attr.getValue());
    }

    public <T> T parseRequiredElemValue(Element parent, String name, XMLValueParser<T> parser) throws ParseException {
        Element child = this.getChild(parent, name);
        if (child == null) {
            throw new ParseException("Element \"" + name + "\" not found");
        }
        String content = this.parseStringContent(child);
        return parser.parse(content);
    }

    public <T> T parseRequiredAttrValue(Element elem, String name, XMLValueParser<T> parser) throws ParseException {
        Attr attr = elem.getAttributeNode(name);
        if (attr == null) {
            throw new ParseException("Attribute \"" + name + "\" not found");
        }
        return parser.parse(attr.getValue());
    }

    public <T> T parseContent(Element elem, XMLValueParser<T> parser) throws ParseException {
        String content = this.parseStringContent(elem);
        return parser.parse(content);
    }

    public String parseStringContent(Element elem) {
        NodeList nodes = elem.getChildNodes();
        String result = "";
        boolean prevNodeIsText = false;
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 3) {
                prevNodeIsText = false;
                continue;
            }
            String val = node.getNodeValue();
            if (!prevNodeIsText) {
                result = result.trim();
                String post = val.replaceAll("^\\s+", "");
                if (result.length() > 0 && post.length() > 0) {
                    result = result + " ";
                }
                result = result + post;
                continue;
            }
            result = result + val;
        }
        return result.trim();
    }

    public Element getChild(Element parent, String name) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !node.getNodeName().equals(name)) continue;
            return (Element)node;
        }
        return null;
    }
}

