/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import eu.woolplatform.utils.exception.ParseException;
import eu.woolplatform.utils.json.JsonObject;
import eu.woolplatform.utils.xml.XMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLObject
extends JsonObject {
    public void writeXml(File file) throws IOException {
        try (FileOutputStream output = new FileOutputStream(file);){
            this.writeXml(output);
        }
    }

    public void writeXml(OutputStream output) throws IOException {
        this.writeXml(new OutputStreamWriter(output, "UTF-8"));
    }

    public void writeXml(Writer writer) throws IOException {
        this.writeXml(new XMLWriter(writer));
    }

    public abstract void writeXml(XMLWriter var1) throws IOException;

    public void readXml(URL url) throws ParseException, IOException {
        try (InputStream input = url.openStream();){
            this.readXml(input);
        }
    }

    public void readXml(File file) throws ParseException, IOException {
        try (FileInputStream input = new FileInputStream(file);){
            this.readXml(input);
        }
    }

    public void readXml(InputStream input) throws ParseException, IOException {
        this.readXml(new InputStreamReader(input, "UTF-8"));
    }

    public void readXml(Reader reader) throws ParseException, IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Can't create document builder: " + ex.getMessage(), ex);
        }
        InputSource source = new InputSource(reader);
        try {
            this.readXml(builder.parse(source));
        }
        catch (SAXException ex) {
            throw new ParseException(ex.getMessage(), ex);
        }
    }

    public void readXml(Document doc) throws ParseException {
        this.readXml(doc.getDocumentElement());
    }

    public abstract void readXml(Element var1) throws ParseException;
}

