/*
 * Decompiled with CFR 0.152.
 */
package eu.woolplatform.utils.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLWriter {
    private String newline;
    private BufferedWriter writer;
    private List<String> elemStack = new ArrayList<String>();
    private Position position = Position.END_ELEMENT;

    public XMLWriter(OutputStream out) throws IOException {
        this.writer = new BufferedWriter(new OutputStreamWriter(out, Charset.forName("UTF-8")));
        this.init();
    }

    public XMLWriter(Writer writer) throws IOException {
        this.writer = new BufferedWriter(writer);
        this.init();
    }

    private void init() throws IOException {
        this.newline = System.getProperty("line.separator");
        this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writer.write(this.newline);
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeStartElement(String name) throws IOException {
        switch (this.position) {
            case START_ELEMENT: {
                this.writer.write(">");
                this.writer.write(this.newline);
                this.writeIndent(this.elemStack.size());
                break;
            }
            case CHARACTERS: {
                break;
            }
            case END_ELEMENT: {
                this.writer.write(this.newline);
                this.writeIndent(this.elemStack.size());
            }
        }
        this.writer.write("<");
        this.writer.write(name);
        this.position = Position.START_ELEMENT;
        this.elemStack.add(0, name);
    }

    public void writeAttribute(String name, String value) throws IOException {
        if (this.position != Position.START_ELEMENT) {
            throw new IOException("Attributes are only allowed in the start tag of an element");
        }
        this.writer.write(" ");
        this.writer.write(name);
        this.writer.write("=\"");
        this.writeEscape(value);
        this.writer.write("\"");
    }

    public void writeEndElement() throws IOException {
        if (this.elemStack.size() == 0) {
            throw new IOException("Can't write end of element, because no matching start was found");
        }
        String name = this.elemStack.remove(0);
        switch (this.position) {
            case START_ELEMENT: {
                this.writer.write(" />");
                break;
            }
            case CHARACTERS: {
                this.writeEndTag(name);
                break;
            }
            case END_ELEMENT: {
                this.writer.write(this.newline);
                this.writeIndent(this.elemStack.size());
                this.writeEndTag(name);
            }
        }
        this.position = Position.END_ELEMENT;
    }

    public void writeCharacters(String s) throws IOException {
        if (this.position == Position.START_ELEMENT) {
            this.writer.write(">");
        }
        this.writeEscape(s);
        this.position = Position.CHARACTERS;
    }

    public void writeElement(String xml) throws IOException {
        Document document;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException("Can't create DocumentBuilder: " + ex.getMessage(), ex);
        }
        StringReader stringReader = new StringReader(xml);
        InputSource source = new InputSource(stringReader);
        try {
            document = builder.parse(source);
        }
        catch (SAXException ex) {
            throw new IOException("Invalid XML: " + ex.getMessage(), ex);
        }
        Element elem = document.getDocumentElement();
        this.writeElement(elem);
    }

    public void writeElement(Element elem) throws IOException {
        this.writeStartElement(elem.getNodeName());
        NamedNodeMap atts = elem.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node attr = atts.item(i);
            this.writeAttribute(attr.getNodeName(), attr.getNodeValue());
        }
        NodeList children = elem.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() == 1) {
                this.writeElement((Element)node);
                continue;
            }
            if (node.getNodeType() != 3) continue;
            this.writeCharacters(node.getNodeValue());
        }
        this.writeEndElement();
    }

    private void writeIndent(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.writer.write("\t");
        }
    }

    private void writeEndTag(String name) throws IOException {
        this.writer.write("</");
        this.writer.write(name);
        this.writer.write(">");
    }

    private void writeEscape(String s) throws IOException {
        this.writer.write(XMLWriter.escapeString(s));
    }

    public static String escapeString(String s) {
        StringBuilder builder = new StringBuilder();
        int start = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String repl = null;
            switch (c) {
                case '&': {
                    repl = "&amp;";
                    break;
                }
                case '<': {
                    repl = "&lt;";
                    break;
                }
                case '>': {
                    repl = "&gt;";
                    break;
                }
                case '\"': {
                    repl = "&quot;";
                    break;
                }
                case '\'': {
                    repl = "&apos;";
                }
            }
            if (repl == null) continue;
            builder.append(s, start, i);
            builder.append(repl);
            start = i + 1;
        }
        if (start < s.length()) {
            builder.append(s, start, s.length());
        }
        return builder.toString();
    }

    private static enum Position {
        START_ELEMENT,
        CHARACTERS,
        END_ELEMENT;

    }
}

