/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import com.google.common.net.InetAddresses;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class AAAAResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private String address;
    private byte[] ipv6Bytes;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        if (this.rdLength == '\u0010') {
            InetAddress ipv6Addres;
            this.ipv6Bytes = buffer.readBytes(16, 16);
            try {
                ipv6Addres = InetAddress.getByAddress(this.ipv6Bytes);
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Illegal ipv6 address", e);
            }
            this.setAddress(InetAddresses.toAddrString((InetAddress)ipv6Addres));
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.ipv6Bytes);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.address;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("address", this.address)).build();
    }

    public String getAddress() {
        return this.address;
    }

    public byte[] getIpv6Bytes() {
        return this.ipv6Bytes;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setIpv6Bytes(byte[] ipv6Bytes) {
        this.ipv6Bytes = ipv6Bytes;
    }

    @Override
    public String toString() {
        return "AAAAResourceRecord(address=" + this.getAddress() + ", ipv6Bytes=" + Arrays.toString(this.getIpv6Bytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AAAAResourceRecord)) {
            return false;
        }
        AAAAResourceRecord other = (AAAAResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        return Arrays.equals(this.getIpv6Bytes(), other.getIpv6Bytes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AAAAResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        result = result * 59 + Arrays.hashCode(this.getIpv6Bytes());
        return result;
    }
}

