/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class NAPTRResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6981260851592320670L;
    private char order;
    private char preference;
    private String flags;
    private String services;
    private String regexp;
    private String replacement;
    private int length;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        this.order = buffer.readUnsignedChar();
        this.preference = buffer.readUnsignedChar();
        this.flags = DNSStringUtil.readLabelData(buffer);
        this.length = 5 + this.flags.length();
        this.services = DNSStringUtil.readLabelData(buffer);
        this.length = this.length + this.services.length() + 1;
        this.regexp = DNSStringUtil.readLabelData(buffer);
        this.length = this.length + this.regexp.length() + 1;
        this.replacement = DNSStringUtil.readName(buffer);
        this.length = this.replacement == null || this.replacement.length() == 0 ? ++this.length : this.length + this.replacement.length() + 1;
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.length);
        buffer.writeChar(this.preference);
        DNSStringUtil.writeLabelData(this.flags, buffer);
        DNSStringUtil.writeLabelData(this.services, buffer);
        DNSStringUtil.writeLabelData(this.regexp, buffer);
        DNSStringUtil.writeName(this.replacement, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.order + " " + this.preference + " \"" + this.flags + "\" \"" + this.services + "\" \"" + this.regexp + "\" " + this.replacement;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("order", (int)this.order).add("preference", (int)this.preference).add("flags", this.flags).add("services", this.services).add("regexp", this.regexp).add("replacement", this.replacement).add("length", this.length)).build();
    }

    public char getOrder() {
        return this.order;
    }

    public char getPreference() {
        return this.preference;
    }

    public String getFlags() {
        return this.flags;
    }

    public String getServices() {
        return this.services;
    }

    public String getRegexp() {
        return this.regexp;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public int getLength() {
        return this.length;
    }

    public void setOrder(char order) {
        this.order = order;
    }

    public void setPreference(char preference) {
        this.preference = preference;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public void setServices(String services) {
        this.services = services;
    }

    public void setRegexp(String regexp) {
        this.regexp = regexp;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public String toString() {
        return "NAPTRResourceRecord(order=" + this.getOrder() + ", preference=" + this.getPreference() + ", flags=" + this.getFlags() + ", services=" + this.getServices() + ", regexp=" + this.getRegexp() + ", replacement=" + this.getReplacement() + ", length=" + this.getLength() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NAPTRResourceRecord)) {
            return false;
        }
        NAPTRResourceRecord other = (NAPTRResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        if (this.getPreference() != other.getPreference()) {
            return false;
        }
        String this$flags = this.getFlags();
        String other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !this$flags.equals(other$flags)) {
            return false;
        }
        String this$services = this.getServices();
        String other$services = other.getServices();
        if (this$services == null ? other$services != null : !this$services.equals(other$services)) {
            return false;
        }
        String this$regexp = this.getRegexp();
        String other$regexp = other.getRegexp();
        if (this$regexp == null ? other$regexp != null : !this$regexp.equals(other$regexp)) {
            return false;
        }
        String this$replacement = this.getReplacement();
        String other$replacement = other.getReplacement();
        if (this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement)) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NAPTRResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getOrder();
        result = result * 59 + this.getPreference();
        String $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : $flags.hashCode());
        String $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : $services.hashCode());
        String $regexp = this.getRegexp();
        result = result * 59 + ($regexp == null ? 43 : $regexp.hashCode());
        String $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        result = result * 59 + this.getLength();
        return result;
    }
}

