/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class PTRResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6138339087534370002L;
    private String ptrDname;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        this.ptrDname = DNSStringUtil.readName(buffer);
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.ptrDname.length() + 2);
        DNSStringUtil.writeName(this.ptrDname, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.ptrDname;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("ptrdname", this.ptrDname)).build();
    }

    public String getPtrDname() {
        return this.ptrDname;
    }

    public void setPtrDname(String ptrDname) {
        this.ptrDname = ptrDname;
    }

    @Override
    public String toString() {
        return "PTRResourceRecord(ptrDname=" + this.getPtrDname() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PTRResourceRecord)) {
            return false;
        }
        PTRResourceRecord other = (PTRResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$ptrDname = this.getPtrDname();
        String other$ptrDname = other.getPtrDname();
        return !(this$ptrDname == null ? other$ptrDname != null : !this$ptrDname.equals(other$ptrDname));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PTRResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $ptrDname = this.getPtrDname();
        result = result * 59 + ($ptrDname == null ? 43 : $ptrDname.hashCode());
        return result;
    }
}

