/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import org.apache.commons.codec.binary.Hex;

public class SSHFPResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private short algorithm;
    private short fingerprintType;
    private byte[] fingerprint;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        this.algorithm = buffer.readUnsignedByte();
        this.fingerprintType = buffer.readUnsignedByte();
        this.fingerprint = new byte[this.rdLength - 2];
        buffer.readBytes(this.fingerprint);
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.rdata);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("algorithm", (int)this.algorithm).add("fptype", (int)this.fingerprintType).add("fingerprint", Hex.encodeHexString((byte[])this.fingerprint))).build();
    }

    public short getAlgorithm() {
        return this.algorithm;
    }

    public short getFingerprintType() {
        return this.fingerprintType;
    }

    public byte[] getFingerprint() {
        return this.fingerprint;
    }

    public void setAlgorithm(short algorithm) {
        this.algorithm = algorithm;
    }

    public void setFingerprintType(short fingerprintType) {
        this.fingerprintType = fingerprintType;
    }

    public void setFingerprint(byte[] fingerprint) {
        this.fingerprint = fingerprint;
    }

    @Override
    public String toString() {
        return "SSHFPResourceRecord(algorithm=" + this.getAlgorithm() + ", fingerprintType=" + this.getFingerprintType() + ", fingerprint=" + Arrays.toString(this.getFingerprint()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSHFPResourceRecord)) {
            return false;
        }
        SSHFPResourceRecord other = (SSHFPResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAlgorithm() != other.getAlgorithm()) {
            return false;
        }
        if (this.getFingerprintType() != other.getFingerprintType()) {
            return false;
        }
        return Arrays.equals(this.getFingerprint(), other.getFingerprint());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SSHFPResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAlgorithm();
        result = result * 59 + this.getFingerprintType();
        result = result * 59 + Arrays.hashCode(this.getFingerprint());
        return result;
    }
}

