/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class TXTResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    protected String value = "";
    protected byte[] data;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        int bytesRead = 0;
        StringBuilder builder = new StringBuilder();
        while (bytesRead < this.rdLength) {
            short stringLength = buffer.readUnsignedByte();
            this.data = new byte[stringLength];
            buffer.readBytes(this.data);
            builder.append(new String(this.data));
            bytesRead = bytesRead + stringLength + 1;
        }
        this.value = builder.toString();
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeByte(this.data.length);
        buffer.writeBytes(this.data);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.value;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("txt-data", this.value)).build();
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "TXTResourceRecord(value=" + this.getValue() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TXTResourceRecord)) {
            return false;
        }
        TXTResourceRecord other = (TXTResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TXTResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        return result;
    }
}

