/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.DigestType;
import org.apache.commons.codec.binary.Hex;

public class NSEC3ParamResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private DigestType hashAlgorithm;
    private short flags;
    private boolean optout;
    private char iterations;
    private short saltLength;
    private byte[] salt;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        this.hashAlgorithm = DigestType.fromValue(buffer.readUnsignedByte());
        this.flags = buffer.readUnsignedByte();
        this.optout = (this.flags & 1) == 1;
        this.iterations = buffer.readUnsignedChar();
        this.saltLength = buffer.readUnsignedByte();
        if (this.saltLength > 0) {
            this.salt = new byte[this.saltLength];
            buffer.readBytes(this.salt);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.rdata);
    }

    @Override
    public String toZone(int maxLength) {
        StringBuilder b = new StringBuilder();
        b.append(super.toZone(maxLength) + "\t" + this.hashAlgorithm.getValue() + " " + this.flags + " " + this.iterations + " ");
        if (this.saltLength == 0) {
            b.append("- ");
        } else {
            b.append(Hex.encodeHexString((byte[])this.salt) + " ");
        }
        return b.toString();
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("hash-algorithm", this.hashAlgorithm.name()).add("flags", (int)this.flags).add("optout", this.optout).add("iterations", (int)this.iterations).add("salt-length", (int)this.saltLength).add("salt", Hex.encodeHexString((byte[])this.salt))).build();
    }

    public DigestType getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public short getFlags() {
        return this.flags;
    }

    public boolean isOptout() {
        return this.optout;
    }

    public char getIterations() {
        return this.iterations;
    }

    public short getSaltLength() {
        return this.saltLength;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setHashAlgorithm(DigestType hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public void setOptout(boolean optout) {
        this.optout = optout;
    }

    public void setIterations(char iterations) {
        this.iterations = iterations;
    }

    public void setSaltLength(short saltLength) {
        this.saltLength = saltLength;
    }

    public void setSalt(byte[] salt) {
        this.salt = salt;
    }

    @Override
    public String toString() {
        return "NSEC3ParamResourceRecord(hashAlgorithm=" + (Object)((Object)this.getHashAlgorithm()) + ", flags=" + this.getFlags() + ", optout=" + this.isOptout() + ", iterations=" + this.getIterations() + ", saltLength=" + this.getSaltLength() + ", salt=" + Arrays.toString(this.getSalt()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NSEC3ParamResourceRecord)) {
            return false;
        }
        NSEC3ParamResourceRecord other = (NSEC3ParamResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DigestType this$hashAlgorithm = this.getHashAlgorithm();
        DigestType other$hashAlgorithm = other.getHashAlgorithm();
        if (this$hashAlgorithm == null ? other$hashAlgorithm != null : !((Object)((Object)this$hashAlgorithm)).equals((Object)other$hashAlgorithm)) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.isOptout() != other.isOptout()) {
            return false;
        }
        if (this.getIterations() != other.getIterations()) {
            return false;
        }
        if (this.getSaltLength() != other.getSaltLength()) {
            return false;
        }
        return Arrays.equals(this.getSalt(), other.getSalt());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NSEC3ParamResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        DigestType $hashAlgorithm = this.getHashAlgorithm();
        result = result * 59 + ($hashAlgorithm == null ? 43 : ((Object)((Object)$hashAlgorithm)).hashCode());
        result = result * 59 + this.getFlags();
        result = result * 59 + (this.isOptout() ? 79 : 97);
        result = result * 59 + this.getIterations();
        result = result * 59 + this.getSaltLength();
        result = result * 59 + Arrays.hashCode(this.getSalt());
        return result;
    }
}

