/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.NSECTypeDecoder;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.TypeMap;

public class NSECResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private String nextDomainName;
    protected List<TypeMap> types = new ArrayList<TypeMap>();

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        this.nextDomainName = DNSStringUtil.readName(buffer);
        int octetAvailable = this.rdLength - (this.nextDomainName.length() + 1);
        new NSECTypeDecoder().decode(octetAvailable, buffer, this.types);
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeBytes(this.getRdata());
    }

    @Override
    public String toString() {
        return "NSECResourceRecord [rdLength=" + this.rdLength + ", nextDomainName=" + this.nextDomainName + "]";
    }

    @Override
    public String toZone(int maxLength) {
        StringBuilder b = new StringBuilder();
        b.append(super.toZone(maxLength) + "\t" + this.nextDomainName + " ");
        for (TypeMap type : this.types) {
            b.append(type.name() + " ");
        }
        return b.toString();
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        builder.add("rdata", Json.createObjectBuilder().add("next-domainname", this.nextDomainName));
        JsonArrayBuilder typeBuilder = Json.createArrayBuilder();
        for (TypeMap type : this.types) {
            typeBuilder.add(type.getType().name());
        }
        return builder.add("types", (JsonValue)typeBuilder.build()).build();
    }

    public String getNextDomainName() {
        return this.nextDomainName;
    }

    public List<TypeMap> getTypes() {
        return this.types;
    }

    public void setNextDomainName(String nextDomainName) {
        this.nextDomainName = nextDomainName;
    }

    public void setTypes(List<TypeMap> types) {
        this.types = types;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NSECResourceRecord)) {
            return false;
        }
        NSECResourceRecord other = (NSECResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$nextDomainName = this.getNextDomainName();
        String other$nextDomainName = other.getNextDomainName();
        if (this$nextDomainName == null ? other$nextDomainName != null : !this$nextDomainName.equals(other$nextDomainName)) {
            return false;
        }
        List<TypeMap> this$types = this.getTypes();
        List<TypeMap> other$types = other.getTypes();
        return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NSECResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $nextDomainName = this.getNextDomainName();
        result = result * 59 + ($nextDomainName == null ? 43 : $nextDomainName.hashCode());
        List<TypeMap> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        return result;
    }
}

