/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.AlgorithmType;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import nl.sidnlabs.dnslib.types.TypeMap;
import nl.sidnlabs.dnslib.util.LabelUtil;
import org.apache.commons.codec.binary.Base64;

public class RRSIGResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("YYYYMMddHHmmss");
    private TypeMap typeCovered;
    private AlgorithmType algorithm;
    private short labels;
    private long originalTtl;
    private long signatureExpiration;
    private long signatureInception;
    private char keytag;
    private String signerName;
    private byte[] signature;
    private boolean wildcard;

    @Override
    public void decode(NetworkData buffer) {
        super.decode(buffer);
        char type = buffer.readUnsignedChar();
        ResourceRecordType rrType = ResourceRecordType.fromValue(type);
        if (rrType == null) {
            rrType = ResourceRecordType.RESERVED;
        }
        this.typeCovered = new TypeMap(rrType, type);
        short alg = buffer.readUnsignedByte();
        this.algorithm = AlgorithmType.fromValue(alg);
        this.labels = buffer.readUnsignedByte();
        this.wildcard = LabelUtil.count(this.getName()) > this.labels;
        this.originalTtl = buffer.readUnsignedInt();
        this.signatureExpiration = buffer.readUnsignedInt();
        this.signatureInception = buffer.readUnsignedInt();
        this.keytag = buffer.readUnsignedChar();
        this.signerName = DNSStringUtil.readName(buffer);
        int signatureLength = this.rdLength;
        signatureLength = this.signerName.length() == 1 ? --signatureLength : (signatureLength -= this.signerName.length() + 1);
        this.signature = new byte[signatureLength -= 18];
        buffer.readBytes(this.signature);
        DATE_FMT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.typeCovered.getValue());
        buffer.writeByte(this.algorithm.getValue());
        buffer.writeByte(this.labels);
        buffer.writeInt((int)this.originalTtl);
        buffer.writeInt((int)this.signatureExpiration);
        buffer.writeInt((int)this.signatureInception);
        buffer.writeChar(this.keytag);
        DNSStringUtil.writeName(this.signerName, buffer);
        buffer.writeBytes(this.signature);
    }

    @Override
    public String toZone(int maxLength) {
        Date exp = new Date();
        exp.setTime(this.signatureExpiration * 1000L);
        Date incep = new Date();
        incep.setTime(this.signatureInception * 1000L);
        SimpleDateFormat fmt = new SimpleDateFormat("YYYYMMddHHmmss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        return super.toZone(maxLength) + "\t" + this.typeCovered.name() + " " + this.algorithm.getValue() + " " + this.labels + " " + this.originalTtl + " " + fmt.format(exp) + "(\n\t\t\t\t\t" + fmt.format(incep) + " " + this.keytag + " " + this.signerName + "\n\t\t\t\t\t" + new Base64(36, "\n\t\t\t\t\t".getBytes()).encodeAsString(this.signature) + " )";
    }

    @Override
    public JsonObject toJSon() {
        Date exp = new Date();
        exp.setTime(this.signatureExpiration * 1000L);
        Date incep = new Date();
        incep.setTime(this.signatureInception * 1000L);
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("type-covered", this.typeCovered.name()).add("algorithm", this.algorithm.name()).add("labels", (int)this.labels).add("original-ttl", this.originalTtl).add("sig-exp", DATE_FMT.format(exp)).add("sig-inc", DATE_FMT.format(incep)).add("keytag", (int)this.keytag).add("signer-name", this.signerName).add("signature", new Base64(Integer.MAX_VALUE, "".getBytes()).encodeAsString(this.signature))).build();
    }

    public boolean getWildcard() {
        return this.wildcard;
    }

    public TypeMap getTypeCovered() {
        return this.typeCovered;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public short getLabels() {
        return this.labels;
    }

    public long getOriginalTtl() {
        return this.originalTtl;
    }

    public long getSignatureExpiration() {
        return this.signatureExpiration;
    }

    public long getSignatureInception() {
        return this.signatureInception;
    }

    public char getKeytag() {
        return this.keytag;
    }

    public String getSignerName() {
        return this.signerName;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setTypeCovered(TypeMap typeCovered) {
        this.typeCovered = typeCovered;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public void setLabels(short labels) {
        this.labels = labels;
    }

    public void setOriginalTtl(long originalTtl) {
        this.originalTtl = originalTtl;
    }

    public void setSignatureExpiration(long signatureExpiration) {
        this.signatureExpiration = signatureExpiration;
    }

    public void setSignatureInception(long signatureInception) {
        this.signatureInception = signatureInception;
    }

    public void setKeytag(char keytag) {
        this.keytag = keytag;
    }

    public void setSignerName(String signerName) {
        this.signerName = signerName;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public void setWildcard(boolean wildcard) {
        this.wildcard = wildcard;
    }

    @Override
    public String toString() {
        return "RRSIGResourceRecord(typeCovered=" + this.getTypeCovered() + ", algorithm=" + (Object)((Object)this.getAlgorithm()) + ", labels=" + this.getLabels() + ", originalTtl=" + this.getOriginalTtl() + ", signatureExpiration=" + this.getSignatureExpiration() + ", signatureInception=" + this.getSignatureInception() + ", keytag=" + this.getKeytag() + ", signerName=" + this.getSignerName() + ", signature=" + Arrays.toString(this.getSignature()) + ", wildcard=" + this.getWildcard() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RRSIGResourceRecord)) {
            return false;
        }
        RRSIGResourceRecord other = (RRSIGResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TypeMap this$typeCovered = this.getTypeCovered();
        TypeMap other$typeCovered = other.getTypeCovered();
        if (this$typeCovered == null ? other$typeCovered != null : !((Object)this$typeCovered).equals(other$typeCovered)) {
            return false;
        }
        AlgorithmType this$algorithm = this.getAlgorithm();
        AlgorithmType other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        if (this.getLabels() != other.getLabels()) {
            return false;
        }
        if (this.getOriginalTtl() != other.getOriginalTtl()) {
            return false;
        }
        if (this.getSignatureExpiration() != other.getSignatureExpiration()) {
            return false;
        }
        if (this.getSignatureInception() != other.getSignatureInception()) {
            return false;
        }
        if (this.getKeytag() != other.getKeytag()) {
            return false;
        }
        String this$signerName = this.getSignerName();
        String other$signerName = other.getSignerName();
        if (this$signerName == null ? other$signerName != null : !this$signerName.equals(other$signerName)) {
            return false;
        }
        if (!Arrays.equals(this.getSignature(), other.getSignature())) {
            return false;
        }
        return this.getWildcard() == other.getWildcard();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RRSIGResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        TypeMap $typeCovered = this.getTypeCovered();
        result = result * 59 + ($typeCovered == null ? 43 : ((Object)$typeCovered).hashCode());
        AlgorithmType $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        result = result * 59 + this.getLabels();
        long $originalTtl = this.getOriginalTtl();
        result = result * 59 + (int)($originalTtl >>> 32 ^ $originalTtl);
        long $signatureExpiration = this.getSignatureExpiration();
        result = result * 59 + (int)($signatureExpiration >>> 32 ^ $signatureExpiration);
        long $signatureInception = this.getSignatureInception();
        result = result * 59 + (int)($signatureInception >>> 32 ^ $signatureInception);
        result = result * 59 + this.getKeytag();
        String $signerName = this.getSignerName();
        result = result * 59 + ($signerName == null ? 43 : $signerName.hashCode());
        result = result * 59 + Arrays.hashCode(this.getSignature());
        result = result * 59 + (this.getWildcard() ? 79 : 97);
        return result;
    }
}

