/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.edns0;

import java.util.ArrayList;
import java.util.List;
import nl.sidnlabs.dnslib.message.records.edns0.EDNS0Option;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import org.apache.commons.lang3.StringUtils;

public class DNSSECOption
extends EDNS0Option {
    public static final int OPTION_CODE_DAU = 5;
    public static final int OPTION_CODE_DHU = 6;
    public static final int OPTION_CODE_N3U = 7;
    private List<Integer> algs;

    public DNSSECOption(int code, int len, NetworkData buffer) {
        super(code, len, buffer);
    }

    public String export() {
        return StringUtils.join(this.algs, (char)',');
    }

    @Override
    public void decode(NetworkData buffer) {
        this.algs = new ArrayList<Integer>();
        for (int i = 0; i < this.len; ++i) {
            short alg = buffer.readUnsignedByte();
            this.algs.add(Integer.valueOf(alg));
        }
    }

    public List<Integer> getAlgs() {
        return this.algs;
    }

    public void setAlgs(List<Integer> algs) {
        this.algs = algs;
    }

    @Override
    public String toString() {
        return "DNSSECOption(algs=" + this.getAlgs() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DNSSECOption)) {
            return false;
        }
        DNSSECOption other = (DNSSECOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Integer> this$algs = this.getAlgs();
        List<Integer> other$algs = other.getAlgs();
        return !(this$algs == null ? other$algs != null : !((Object)this$algs).equals(other$algs));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DNSSECOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Integer> $algs = this.getAlgs();
        result = result * 59 + ($algs == null ? 43 : ((Object)$algs).hashCode());
        return result;
    }
}

