/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.edns0;

import java.util.ArrayList;
import java.util.List;
import nl.sidnlabs.dnslib.message.records.edns0.EDNS0Option;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class KeyTagOption
extends EDNS0Option {
    private List<Integer> keytags;

    public KeyTagOption() {
    }

    public KeyTagOption(int code, int len, NetworkData buffer) {
        super(code, len, buffer);
    }

    @Override
    public void decode(NetworkData buffer) {
        this.keytags = new ArrayList<Integer>();
        if (this.len > 0) {
            if (this.len % 2 == 0) {
                int keys = this.len / 2;
                for (int i = 0; i < keys; ++i) {
                    this.keytags.add(Integer.valueOf(buffer.readUnsignedChar()));
                }
            } else {
                byte[] data = new byte[this.len];
                buffer.readBytes(data);
            }
        }
    }

    public List<Integer> getKeytags() {
        return this.keytags;
    }

    public void setKeytags(List<Integer> keytags) {
        this.keytags = keytags;
    }

    @Override
    public String toString() {
        return "KeyTagOption(keytags=" + this.getKeytags() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyTagOption)) {
            return false;
        }
        KeyTagOption other = (KeyTagOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<Integer> this$keytags = this.getKeytags();
        List<Integer> other$keytags = other.getKeytags();
        return !(this$keytags == null ? other$keytags != null : !((Object)this$keytags).equals(other$keytags));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KeyTagOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<Integer> $keytags = this.getKeytags();
        result = result * 59 + ($keytags == null ? 43 : ((Object)$keytags).hashCode());
        return result;
    }
}

