/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.util;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.exception.DnsEncodeException;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import org.apache.commons.lang3.StringUtils;

public class DNSStringUtil {
    private static final int MAX_CHARACTER_STRING_LENGTH = 255;
    private static final int MAX_POINTER_CHAIN_LENGTH = 10;
    private static final byte UNCOMPRESSED_NAME_BIT_MASK = 63;
    private static final byte COMPRESSED_NAME_BIT_MASK = -64;

    public static boolean isUncompressedName(byte namePrefix) {
        return (namePrefix | 0x3F) == 63;
    }

    public static boolean isCompressedName(byte namePrefix) {
        return (namePrefix & 0xFFFFFFC0) == -64;
    }

    public static String readName(NetworkData buffer) {
        int currentPosition = -1;
        StringBuilder nameBuilder = new StringBuilder();
        short length = buffer.readUnsignedByte();
        if (length == 0) {
            return ".";
        }
        while (length > 0) {
            if (length > 5000) {
                throw new DnsDecodeException("Unsupported label length found, value: " + length);
            }
            if (DNSStringUtil.isUncompressedName((byte)length)) {
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                String label = new String(bytes, Charsets.US_ASCII);
                nameBuilder.append(label);
                nameBuilder.append(".");
            } else if (DNSStringUtil.isCompressedName((byte)length)) {
                if (currentPosition == -1) {
                    currentPosition = buffer.getReaderIndex() + 1;
                }
                DNSStringUtil.followPointerChain(buffer);
            } else {
                throw new DnsDecodeException("Unsupported label type found");
            }
            length = buffer.readUnsignedByte();
        }
        if (currentPosition >= 0) {
            buffer.setReaderIndex(currentPosition);
        }
        return nameBuilder.toString();
    }

    private static void followPointerChain(NetworkData buffer) {
        short length = 0;
        int jumps = 0;
        do {
            buffer.rewind(1);
            if (++jumps == 10) {
                throw new DnsDecodeException("Illegal pointer chain size: " + jumps);
            }
            char offset = buffer.readUnsignedChar();
            offset = (char)(offset ^ 0x4000);
            if ((byte)(offset = (char)(offset ^ 0x8000)) >= buffer.getReaderIndex() - 2) {
                throw new DnsDecodeException("Message compression pointer offset higher than current index");
            }
            buffer.setReaderIndex(offset);
        } while (DNSStringUtil.isCompressedName((byte)(length = buffer.readUnsignedByte())));
        buffer.rewind(1);
    }

    public static void writeName(String name, NetworkData buffer) {
        String[] labels;
        for (String label : labels = StringUtils.split((String)name, (String)".")) {
            buffer.writeByte(label.length());
            buffer.writeBytes(label.getBytes());
        }
        buffer.writeByte(0);
    }

    public static byte[] writeName(String name) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            String[] labels;
            for (String label : labels = StringUtils.split((String)name, (String)".")) {
                dos.writeByte(label.length());
                dos.write(label.getBytes());
            }
            dos.writeByte(0);
        }
        catch (IOException e) {
            throw new DnsEncodeException("Error while writing name", e);
        }
        return bos.toByteArray();
    }

    public static String readLabelData(NetworkData buffer) {
        short length = buffer.readUnsignedByte();
        if (length > 255) {
            throw new DnsDecodeException("Illegal character string length (> 255), length = " + length);
        }
        if (length > 0) {
            byte[] characterString = new byte[length];
            buffer.readBytes(characterString);
            return new String(characterString, Charsets.US_ASCII);
        }
        return "";
    }

    public static void writeLabelData(String value, NetworkData buffer) {
        byte[] data = value.getBytes();
        if (data.length > 255) {
            throw new DnsEncodeException("Illegal character string length (> 255), length = " + data.length);
        }
        if (data.length > 0) {
            buffer.writeByte(data.length);
            buffer.writeBytes(data);
        }
    }
}

