/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.types;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class ResourceRecordClass
extends Enum<ResourceRecordClass> {
    public static final /* enum */ ResourceRecordClass RESERVED;
    public static final /* enum */ ResourceRecordClass IN;
    public static final /* enum */ ResourceRecordClass CH;
    public static final /* enum */ ResourceRecordClass HS;
    public static final /* enum */ ResourceRecordClass NONE;
    public static final /* enum */ ResourceRecordClass ANY;
    public static final /* enum */ ResourceRecordClass UNASSIGNED;
    public static final /* enum */ ResourceRecordClass PRIVATE;
    public static final /* enum */ ResourceRecordClass UNKNOWN;
    private int value;
    private static Map<String, ResourceRecordClass> classes;
    private static Map<Integer, ResourceRecordClass> classesToInt;
    private static final /* synthetic */ ResourceRecordClass[] $VALUES;

    public static ResourceRecordClass[] values() {
        return (ResourceRecordClass[])$VALUES.clone();
    }

    public static ResourceRecordClass valueOf(String name) {
        return Enum.valueOf(ResourceRecordClass.class, name);
    }

    private ResourceRecordClass(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static ResourceRecordClass fromString(String name) {
        return classes.get(StringUtils.upperCase((String)name));
    }

    public static ResourceRecordClass fromValue(int value) {
        ResourceRecordClass classz = classesToInt.get(new Integer(value));
        if (classz == null) {
            if (value == 2 || value >= 5 && value <= 253 || value >= 256 && value <= 65279) {
                return UNASSIGNED;
            }
            if (value >= 65280 && value <= 65534) {
                return PRIVATE;
            }
            return UNKNOWN;
        }
        return classz;
    }

    static {
        ResourceRecordClass[] values;
        RESERVED = new ResourceRecordClass(0);
        IN = new ResourceRecordClass(1);
        CH = new ResourceRecordClass(3);
        HS = new ResourceRecordClass(4);
        NONE = new ResourceRecordClass(254);
        ANY = new ResourceRecordClass(255);
        UNASSIGNED = new ResourceRecordClass(-1);
        PRIVATE = new ResourceRecordClass(-2);
        UNKNOWN = new ResourceRecordClass(-3);
        $VALUES = new ResourceRecordClass[]{RESERVED, IN, CH, HS, NONE, ANY, UNASSIGNED, PRIVATE, UNKNOWN};
        classes = new HashMap<String, ResourceRecordClass>();
        classesToInt = new HashMap<Integer, ResourceRecordClass>();
        for (ResourceRecordClass classz : values = ResourceRecordClass.values()) {
            classes.put(classz.name(), classz);
            classesToInt.put(new Integer(classz.getValue()), classz);
        }
    }
}

