/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import java.util.List;
import java.util.regex.Pattern;
import nl.sidnlabs.dnslib.util.DomainParent;
import nl.sidnlabs.dnslib.util.Domaininfo;
import org.apache.commons.lang3.StringUtils;

public class NameUtil {
    private static final String DOMAIN_NAME_PATTERN = "^((?!-)[A-Za-z0-9-_]{1,63}(?<!-)\\.)*([A-Za-z]{2,2})*(\\.)*$";
    private static final Pattern FQDN = Pattern.compile("^((?!-)[A-Za-z0-9-_]{1,63}(?<!-)\\.)*([A-Za-z]{2,2})*(\\.)*$");

    private NameUtil() {
    }

    public static Domaininfo getDomain(String name) {
        if (name == null || name.length() == 0) {
            return new Domaininfo(null, 0);
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)".")) {
            return new Domaininfo(name, 0);
        }
        String[] parts = StringUtils.split((String)name, (String)".");
        if (parts != null && parts.length > 0) {
            if (parts.length == 1) {
                return new Domaininfo(parts[0], 1);
            }
            return new Domaininfo(parts[parts.length - 2] + "." + parts[parts.length - 1], parts.length);
        }
        return new Domaininfo(name, 0);
    }

    public static Domaininfo getDomain(String name, List<DomainParent> parents) {
        if (parents != null && !parents.isEmpty()) {
            return NameUtil.getDomainWithSuffixList(name, parents);
        }
        return NameUtil.getDomain(name);
    }

    public static Domaininfo getDomainWithSuffixList(String name, List<DomainParent> parents) {
        if (name == null || name.length() == 0) {
            return new Domaininfo(null, 0);
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)".")) {
            return new Domaininfo(name, 0);
        }
        String[] parts = StringUtils.split((String)name, (String)".");
        if (parts != null && parts.length > 0) {
            if (parts.length == 1) {
                return new Domaininfo(parts[0], 1);
            }
            for (DomainParent parent : parents) {
                if (!StringUtils.endsWith((CharSequence)name, (CharSequence)parent.getMatch())) continue;
                return new Domaininfo(parts[parts.length - (parent.getLabels() + 1)] + parent.getParent(), parts.length);
            }
            return new Domaininfo(parts[parts.length - 2] + "." + parts[parts.length - 1], parts.length);
        }
        return new Domaininfo(name, 0);
    }

    public static boolean isFqdn(String domain) {
        return FQDN.matcher(domain).find();
    }

    public static String getSecondLevel(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        String[] parts = StringUtils.split((String)name, (char)'.');
        if (parts.length == 0) {
            return name;
        }
        if (parts.length == 1) {
            return parts[parts.length - 1];
        }
        return parts[parts.length - 2] + "." + parts[parts.length - 1];
    }
}

