/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message;

import javax.json.Json;
import javax.json.JsonObject;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.MessageType;
import nl.sidnlabs.dnslib.types.OpcodeType;
import nl.sidnlabs.dnslib.types.RcodeType;

public class Header {
    private static final int QR_QUERY_BIT_MASK = 32768;
    private static final int AA_BIT_MASK = 1024;
    private static final int TC_BIT_MASK = 512;
    private static final int RD_BIT_MASK = 256;
    private static final int RA_BIT_MASK = 128;
    private static final int Z_BIT_MASK = 64;
    private static final int AD_BIT_MASK = 32;
    private static final int CD_BIT_MASK = 16;
    private static final int OPCODE_MASK = 30720;
    private static final int RCODE_MASK = 15;
    private int id;
    private MessageType qr = MessageType.QUERY;
    private OpcodeType opCode;
    private boolean aa;
    private boolean tc;
    private boolean rd;
    private boolean ra;
    private boolean z;
    private boolean ad;
    private boolean cd;
    private RcodeType rcode;
    private char qdCount;
    private char anCount;
    private char nsCount;
    private char arCount;
    private int rawOpcode;
    private int rawRcode;

    public void decode(NetworkData buffer) {
        this.setId(buffer.readUnsignedChar());
        this.decodeFlags(buffer);
        this.setQdCount(buffer.readUnsignedChar());
        this.setAnCount(buffer.readUnsignedChar());
        this.setNsCount(buffer.readUnsignedChar());
        this.setArCount(buffer.readUnsignedChar());
    }

    private void decodeFlags(NetworkData buffer) {
        char flags = buffer.readUnsignedChar();
        if ((flags & 0x8000) == 32768) {
            this.setQr(MessageType.RESPONSE);
        } else {
            this.setQr(MessageType.QUERY);
        }
        this.rawOpcode = flags & 0x7800;
        this.rawOpcode >>>= 11;
        if (this.rawOpcode == OpcodeType.STANDARD.getValue()) {
            this.setOpCode(OpcodeType.STANDARD);
        } else if (this.rawOpcode == OpcodeType.INVERSE.getValue()) {
            this.setOpCode(OpcodeType.INVERSE);
        } else if (this.rawOpcode == OpcodeType.STATUS.getValue()) {
            this.setOpCode(OpcodeType.STATUS);
        } else if (this.rawOpcode == OpcodeType.NOTIFY.getValue()) {
            this.setOpCode(OpcodeType.NOTIFY);
        } else if (this.rawOpcode == OpcodeType.UPPDATE.getValue()) {
            this.setOpCode(OpcodeType.UPPDATE);
        } else {
            this.setOpCode(OpcodeType.UNASSIGNED);
        }
        this.setAa((flags & 0x400) == 1024);
        this.setTc((flags & 0x200) == 512);
        this.setRd((flags & 0x100) == 256);
        this.setRa((flags & 0x80) == 128);
        this.setZ((flags & 0x40) == 64);
        this.setAd((flags & 0x20) == 32);
        this.setCd((flags & 0x10) == 16);
        this.rawRcode = flags & 0xF;
        this.setRcode(RcodeType.fromValue(this.rawRcode));
    }

    public void encode(NetworkData buffer) {
        buffer.writeChar(this.getId());
        int flags = 0;
        if (this.qr == MessageType.RESPONSE) {
            flags = (char)(flags | 0x8000);
        }
        if (this.opCode == OpcodeType.INVERSE) {
            flags = (char)(flags | 0x800);
        } else if (this.opCode == OpcodeType.STATUS) {
            flags = (char)(flags | 0x1000);
        }
        if (this.aa) {
            flags = (char)(flags | 0x400);
        }
        if (this.tc) {
            flags = (char)(flags | 0x200);
        }
        if (this.rd) {
            flags = (char)(flags | 0x100);
        }
        if (this.ra) {
            flags = (char)(flags | 0x80);
        }
        if (this.z) {
            flags = (char)(flags | 0x40);
        }
        if (this.ad) {
            flags = (char)(flags | 0x20);
        }
        if (this.cd) {
            flags = (char)(flags | 0x10);
        }
        if (this.rcode == RcodeType.FORMAT_ERROR) {
            flags = (char)(flags | 1);
        } else if (this.rcode == RcodeType.SERVER_FAILURE) {
            flags = (char)(flags | 2);
        } else if (this.rcode == RcodeType.NXDOMAIN) {
            flags = (char)(flags | 3);
        } else if (this.rcode == RcodeType.NOT_IMPLEMENTED) {
            flags = (char)(flags | 4);
        } else if (this.rcode == RcodeType.REFUSED) {
            flags = (char)(flags | 5);
        }
        buffer.writeChar(flags);
        buffer.writeChar(this.getQdCount());
        buffer.writeChar(this.getAnCount());
        buffer.writeChar(this.getNsCount());
        buffer.writeChar(this.getArCount());
    }

    public static Header createResponseHeader(char id) {
        Header hdr = new Header();
        hdr.setId(id);
        hdr.setQr(MessageType.RESPONSE);
        return hdr;
    }

    public String toZone() {
        return "flags: aa:" + this.aa + ", tc:" + this.tc + ", rd:" + this.rd + ", ra:" + this.ra + ", ad:" + this.ad + ", cd:" + this.cd + ", rcode:" + (Object)((Object)this.rcode) + ", qdCount:" + this.qdCount + ", anCount:" + this.anCount + ", nsCount:" + this.nsCount + ", arCount:" + this.arCount;
    }

    public JsonObject toJSon() {
        return Json.createObjectBuilder().add("id", this.id).add("qr", this.qr.getValue()).add("opcode", this.opCode.getValue()).add("flags", Json.createObjectBuilder().add("aa", this.aa).add("tc", this.tc).add("rd", this.rd).add("ra", this.ra).add("ad", this.ad).add("cd", this.cd)).add("rcode", this.rcode.name()).add("qdCount", (int)this.qdCount).add("anCount", (int)this.anCount).add("nsCount", (int)this.nsCount).add("arCount", (int)this.arCount).build();
    }

    public int getId() {
        return this.id;
    }

    public MessageType getQr() {
        return this.qr;
    }

    public OpcodeType getOpCode() {
        return this.opCode;
    }

    public boolean isAa() {
        return this.aa;
    }

    public boolean isTc() {
        return this.tc;
    }

    public boolean isRd() {
        return this.rd;
    }

    public boolean isRa() {
        return this.ra;
    }

    public boolean isZ() {
        return this.z;
    }

    public boolean isAd() {
        return this.ad;
    }

    public boolean isCd() {
        return this.cd;
    }

    public RcodeType getRcode() {
        return this.rcode;
    }

    public char getQdCount() {
        return this.qdCount;
    }

    public char getAnCount() {
        return this.anCount;
    }

    public char getNsCount() {
        return this.nsCount;
    }

    public char getArCount() {
        return this.arCount;
    }

    public int getRawOpcode() {
        return this.rawOpcode;
    }

    public int getRawRcode() {
        return this.rawRcode;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setQr(MessageType qr) {
        this.qr = qr;
    }

    public void setOpCode(OpcodeType opCode) {
        this.opCode = opCode;
    }

    public void setAa(boolean aa) {
        this.aa = aa;
    }

    public void setTc(boolean tc) {
        this.tc = tc;
    }

    public void setRd(boolean rd) {
        this.rd = rd;
    }

    public void setRa(boolean ra) {
        this.ra = ra;
    }

    public void setZ(boolean z) {
        this.z = z;
    }

    public void setAd(boolean ad) {
        this.ad = ad;
    }

    public void setCd(boolean cd) {
        this.cd = cd;
    }

    public void setRcode(RcodeType rcode) {
        this.rcode = rcode;
    }

    public void setQdCount(char qdCount) {
        this.qdCount = qdCount;
    }

    public void setAnCount(char anCount) {
        this.anCount = anCount;
    }

    public void setNsCount(char nsCount) {
        this.nsCount = nsCount;
    }

    public void setArCount(char arCount) {
        this.arCount = arCount;
    }

    public void setRawOpcode(int rawOpcode) {
        this.rawOpcode = rawOpcode;
    }

    public void setRawRcode(int rawRcode) {
        this.rawRcode = rawRcode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Header)) {
            return false;
        }
        Header other = (Header)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        MessageType this$qr = this.getQr();
        MessageType other$qr = other.getQr();
        if (this$qr == null ? other$qr != null : !((Object)((Object)this$qr)).equals((Object)other$qr)) {
            return false;
        }
        OpcodeType this$opCode = this.getOpCode();
        OpcodeType other$opCode = other.getOpCode();
        if (this$opCode == null ? other$opCode != null : !((Object)((Object)this$opCode)).equals((Object)other$opCode)) {
            return false;
        }
        if (this.isAa() != other.isAa()) {
            return false;
        }
        if (this.isTc() != other.isTc()) {
            return false;
        }
        if (this.isRd() != other.isRd()) {
            return false;
        }
        if (this.isRa() != other.isRa()) {
            return false;
        }
        if (this.isZ() != other.isZ()) {
            return false;
        }
        if (this.isAd() != other.isAd()) {
            return false;
        }
        if (this.isCd() != other.isCd()) {
            return false;
        }
        RcodeType this$rcode = this.getRcode();
        RcodeType other$rcode = other.getRcode();
        if (this$rcode == null ? other$rcode != null : !((Object)((Object)this$rcode)).equals((Object)other$rcode)) {
            return false;
        }
        if (this.getQdCount() != other.getQdCount()) {
            return false;
        }
        if (this.getAnCount() != other.getAnCount()) {
            return false;
        }
        if (this.getNsCount() != other.getNsCount()) {
            return false;
        }
        if (this.getArCount() != other.getArCount()) {
            return false;
        }
        if (this.getRawOpcode() != other.getRawOpcode()) {
            return false;
        }
        return this.getRawRcode() == other.getRawRcode();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Header;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        MessageType $qr = this.getQr();
        result = result * 59 + ($qr == null ? 43 : ((Object)((Object)$qr)).hashCode());
        OpcodeType $opCode = this.getOpCode();
        result = result * 59 + ($opCode == null ? 43 : ((Object)((Object)$opCode)).hashCode());
        result = result * 59 + (this.isAa() ? 79 : 97);
        result = result * 59 + (this.isTc() ? 79 : 97);
        result = result * 59 + (this.isRd() ? 79 : 97);
        result = result * 59 + (this.isRa() ? 79 : 97);
        result = result * 59 + (this.isZ() ? 79 : 97);
        result = result * 59 + (this.isAd() ? 79 : 97);
        result = result * 59 + (this.isCd() ? 79 : 97);
        RcodeType $rcode = this.getRcode();
        result = result * 59 + ($rcode == null ? 43 : ((Object)((Object)$rcode)).hashCode());
        result = result * 59 + this.getQdCount();
        result = result * 59 + this.getAnCount();
        result = result * 59 + this.getNsCount();
        result = result * 59 + this.getArCount();
        result = result * 59 + this.getRawOpcode();
        result = result * 59 + this.getRawRcode();
        return result;
    }

    public String toString() {
        return "Header(id=" + this.getId() + ", qr=" + (Object)((Object)this.getQr()) + ", opCode=" + (Object)((Object)this.getOpCode()) + ", aa=" + this.isAa() + ", tc=" + this.isTc() + ", rd=" + this.isRd() + ", ra=" + this.isRa() + ", z=" + this.isZ() + ", ad=" + this.isAd() + ", cd=" + this.isCd() + ", rcode=" + (Object)((Object)this.getRcode()) + ", qdCount=" + this.getQdCount() + ", anCount=" + this.getAnCount() + ", nsCount=" + this.getNsCount() + ", arCount=" + this.getArCount() + ", rawOpcode=" + this.getRawOpcode() + ", rawRcode=" + this.getRawRcode() + ")";
    }
}

