/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class AResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = -1960441085310394001L;
    private String address;
    private int[] ipv4Bytes;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial && this.rdLength == '\u0004') {
            InetAddress ip;
            byte[] addrBytes = buffer.readBytes(4, 4);
            try {
                ip = InetAddress.getByAddress(addrBytes);
            }
            catch (UnknownHostException e) {
                throw new DnsDecodeException("Invalid IP address", e);
            }
            this.setAddress(ip.getHostAddress());
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        if (this.ipv4Bytes != null && this.ipv4Bytes.length == 4) {
            for (int i = 0; i < 4; ++i) {
                buffer.writeByte(this.ipv4Bytes[i]);
            }
        }
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.address;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("address", this.address)).build();
    }

    public String getAddress() {
        return this.address;
    }

    public int[] getIpv4Bytes() {
        return this.ipv4Bytes;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setIpv4Bytes(int[] ipv4Bytes) {
        this.ipv4Bytes = ipv4Bytes;
    }

    @Override
    public String toString() {
        return "AResourceRecord(address=" + this.getAddress() + ", ipv4Bytes=" + Arrays.toString(this.getIpv4Bytes()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AResourceRecord)) {
            return false;
        }
        AResourceRecord other = (AResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        return Arrays.equals(this.getIpv4Bytes(), other.getIpv4Bytes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        result = result * 59 + Arrays.hashCode(this.getIpv4Bytes());
        return result;
    }
}

