/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import java.io.Serializable;
import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.ResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.ResourceRecordClass;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractResourceRecord
implements ResourceRecord,
Serializable {
    private static final long serialVersionUID = -2781381098732827757L;
    protected String name;
    protected char rawType;
    protected char rawClassz;
    protected ResourceRecordType type;
    protected ResourceRecordClass classz;
    protected long ttl;
    protected char rdLength;
    protected byte[] rdata;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        this.setName(DNSStringUtil.readName(buffer));
        this.rawType = buffer.readUnsignedChar();
        this.setType(ResourceRecordType.fromValue(this.rawType));
        this.rawClassz = buffer.readUnsignedChar();
        this.setClassz(ResourceRecordClass.fromValue(this.rawClassz));
        this.setTtl(buffer.readUnsignedInt());
        this.rdLength = buffer.readUnsignedChar();
        if (partial) {
            buffer.setReaderIndex(buffer.getReaderIndex() + this.rdLength);
        } else if (this.rdLength <= buffer.bytesAvailable()) {
            buffer.markReaderIndex();
            this.rdata = new byte[this.rdLength];
            buffer.readBytes(this.rdata);
            buffer.resetReaderIndex();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        DNSStringUtil.writeName(this.getName(), buffer);
        buffer.writeChar(this.getType().getValue());
        buffer.writeChar(this.getClassz().getValue());
        buffer.writeInt((int)this.getTtl());
    }

    public int getRawType() {
        return this.rawType;
    }

    public int getRawClassz() {
        return this.rawClassz;
    }

    @Override
    public String toZone(int maxLength) {
        int paddedSize = maxLength - this.name.length() + this.name.length();
        String ownerWithPadding = StringUtils.rightPad((String)this.name, (int)paddedSize, (String)" ");
        return ownerWithPadding + "\t" + this.ttl + "\t" + (Object)((Object)this.classz) + "\t" + (Object)((Object)this.type);
    }

    public JsonObjectBuilder createJsonBuilder() {
        return Json.createObjectBuilder().add("name", this.name).add("type", this.type.name()).add("class", this.classz.name()).add("ttl", this.ttl).add("rdLength", (int)this.rdLength);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = this.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("dummy", "toddo")).build();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ResourceRecordType getType() {
        return this.type;
    }

    @Override
    public ResourceRecordClass getClassz() {
        return this.classz;
    }

    @Override
    public long getTtl() {
        return this.ttl;
    }

    @Override
    public char getRdLength() {
        return this.rdLength;
    }

    @Override
    public byte[] getRdata() {
        return this.rdata;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setRawType(char rawType) {
        this.rawType = rawType;
    }

    public void setRawClassz(char rawClassz) {
        this.rawClassz = rawClassz;
    }

    @Override
    public void setType(ResourceRecordType type) {
        this.type = type;
    }

    @Override
    public void setClassz(ResourceRecordClass classz) {
        this.classz = classz;
    }

    @Override
    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public void setRdLength(char rdLength) {
        this.rdLength = rdLength;
    }

    public void setRdata(byte[] rdata) {
        this.rdata = rdata;
    }

    public String toString() {
        return "AbstractResourceRecord(name=" + this.getName() + ", rawType=" + this.getRawType() + ", rawClassz=" + this.getRawClassz() + ", type=" + (Object)((Object)this.getType()) + ", classz=" + (Object)((Object)this.getClassz()) + ", ttl=" + this.getTtl() + ", rdLength=" + this.getRdLength() + ", rdata=" + Arrays.toString(this.getRdata()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractResourceRecord)) {
            return false;
        }
        AbstractResourceRecord other = (AbstractResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        if (this.getRawType() != other.getRawType()) {
            return false;
        }
        if (this.getRawClassz() != other.getRawClassz()) {
            return false;
        }
        ResourceRecordType this$type = this.getType();
        ResourceRecordType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ResourceRecordClass this$classz = this.getClassz();
        ResourceRecordClass other$classz = other.getClassz();
        if (this$classz == null ? other$classz != null : !((Object)((Object)this$classz)).equals((Object)other$classz)) {
            return false;
        }
        if (this.getTtl() != other.getTtl()) {
            return false;
        }
        if (this.getRdLength() != other.getRdLength()) {
            return false;
        }
        return Arrays.equals(this.getRdata(), other.getRdata());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractResourceRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        result = result * 59 + this.getRawType();
        result = result * 59 + this.getRawClassz();
        ResourceRecordType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ResourceRecordClass $classz = this.getClassz();
        result = result * 59 + ($classz == null ? 43 : ((Object)((Object)$classz)).hashCode());
        long $ttl = this.getTtl();
        result = result * 59 + (int)($ttl >>> 32 ^ $ttl);
        result = result * 59 + this.getRdLength();
        result = result * 59 + Arrays.hashCode(this.getRdata());
        return result;
    }
}

