/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class MXResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 6877262886026363052L;
    private char preference;
    private String exchange;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.preference = buffer.readUnsignedChar();
            this.exchange = DNSStringUtil.readName(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.exchange.length() + 2 + 2);
        buffer.writeChar(this.preference);
        DNSStringUtil.writeName(this.exchange, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.preference + " " + this.exchange;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("preference", (int)this.preference).add("exchange", this.exchange)).build();
    }

    public char getPreference() {
        return this.preference;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setPreference(char preference) {
        this.preference = preference;
    }

    public void setExchange(String exchange) {
        this.exchange = exchange;
    }

    @Override
    public String toString() {
        return "MXResourceRecord(preference=" + this.getPreference() + ", exchange=" + this.getExchange() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MXResourceRecord)) {
            return false;
        }
        MXResourceRecord other = (MXResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPreference() != other.getPreference()) {
            return false;
        }
        String this$exchange = this.getExchange();
        String other$exchange = other.getExchange();
        return !(this$exchange == null ? other$exchange != null : !this$exchange.equals(other$exchange));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MXResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPreference();
        String $exchange = this.getExchange();
        result = result * 59 + ($exchange == null ? 43 : $exchange.hashCode());
        return result;
    }
}

