/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class NSResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1023178649874976277L;
    private String nameserver;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.setNameserver(DNSStringUtil.readName(buffer));
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.nameserver.length() + 2);
        DNSStringUtil.writeName(this.nameserver, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.nameserver;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("nameserver", this.nameserver)).build();
    }

    public String getNameserver() {
        return this.nameserver;
    }

    public void setNameserver(String nameserver) {
        this.nameserver = nameserver;
    }

    @Override
    public String toString() {
        return "NSResourceRecord(nameserver=" + this.getNameserver() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NSResourceRecord)) {
            return false;
        }
        NSResourceRecord other = (NSResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$nameserver = this.getNameserver();
        String other$nameserver = other.getNameserver();
        return !(this$nameserver == null ? other$nameserver != null : !this$nameserver.equals(other$nameserver));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof NSResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $nameserver = this.getNameserver();
        result = result * 59 + ($nameserver == null ? 43 : $nameserver.hashCode());
        return result;
    }
}

