/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.security.PublicKey;
import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.AlgorithmType;
import nl.sidnlabs.dnslib.util.KeyUtil;
import org.apache.commons.codec.binary.Base64;

public class DNSKEYResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private char flags;
    private short protocol;
    private AlgorithmType algorithm;
    private PublicKey publicKey;
    private byte[] keydata;
    private int keytag;
    private boolean isZoneKey;
    private boolean isSepKey;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.flags = buffer.readUnsignedChar();
            this.protocol = buffer.readUnsignedByte();
            short alg = buffer.readUnsignedByte();
            this.algorithm = AlgorithmType.fromValue(alg);
            char keysize = (char)(this.rdLength - 4);
            this.keydata = new byte[keysize];
            buffer.readBytes(this.keydata);
            this.publicKey = KeyUtil.createPublicKey(this.keydata, alg);
            this.keytag = KeyUtil.createKeyTag(this.rdata, alg);
            this.isZoneKey = KeyUtil.isZoneKey(this);
            this.isSepKey = KeyUtil.isSepKey(this);
        }
    }

    public boolean isValid() {
        if (this.protocol != 3) {
            return false;
        }
        return this.flags == '\u0000' || this.flags == '\u0100' || this.flags == '\u0101';
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.flags);
        buffer.writeByte(this.protocol);
        buffer.writeByte(this.algorithm.getValue());
        buffer.writeBytes(this.keydata);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + " " + this.flags + " " + this.protocol + " " + this.algorithm.getValue() + "(\n\t\t\t\t\t\t" + new Base64(36, "\n\t\t\t\t\t\t".getBytes()).encodeAsString(this.keydata) + " )";
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("flags", (int)this.flags)).add("protocol", (int)this.protocol).add("algorithm", this.algorithm.name()).add("zone-key", this.isZoneKey).add("sep-key", this.isSepKey).add("keytag", this.keytag).build();
    }

    public char getFlags() {
        return this.flags;
    }

    public short getProtocol() {
        return this.protocol;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getKeydata() {
        return this.keydata;
    }

    public int getKeytag() {
        return this.keytag;
    }

    public boolean isZoneKey() {
        return this.isZoneKey;
    }

    public boolean isSepKey() {
        return this.isSepKey;
    }

    public void setFlags(char flags) {
        this.flags = flags;
    }

    public void setProtocol(short protocol) {
        this.protocol = protocol;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setKeydata(byte[] keydata) {
        this.keydata = keydata;
    }

    public void setKeytag(int keytag) {
        this.keytag = keytag;
    }

    public void setZoneKey(boolean isZoneKey) {
        this.isZoneKey = isZoneKey;
    }

    public void setSepKey(boolean isSepKey) {
        this.isSepKey = isSepKey;
    }

    @Override
    public String toString() {
        return "DNSKEYResourceRecord(flags=" + this.getFlags() + ", protocol=" + this.getProtocol() + ", algorithm=" + (Object)((Object)this.getAlgorithm()) + ", publicKey=" + this.getPublicKey() + ", keydata=" + Arrays.toString(this.getKeydata()) + ", keytag=" + this.getKeytag() + ", isZoneKey=" + this.isZoneKey() + ", isSepKey=" + this.isSepKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DNSKEYResourceRecord)) {
            return false;
        }
        DNSKEYResourceRecord other = (DNSKEYResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getProtocol() != other.getProtocol()) {
            return false;
        }
        AlgorithmType this$algorithm = this.getAlgorithm();
        AlgorithmType other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        PublicKey this$publicKey = this.getPublicKey();
        PublicKey other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        if (!Arrays.equals(this.getKeydata(), other.getKeydata())) {
            return false;
        }
        if (this.getKeytag() != other.getKeytag()) {
            return false;
        }
        if (this.isZoneKey() != other.isZoneKey()) {
            return false;
        }
        return this.isSepKey() == other.isSepKey();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DNSKEYResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getFlags();
        result = result * 59 + this.getProtocol();
        AlgorithmType $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        PublicKey $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        result = result * 59 + Arrays.hashCode(this.getKeydata());
        result = result * 59 + this.getKeytag();
        result = result * 59 + (this.isZoneKey() ? 79 : 97);
        result = result * 59 + (this.isSepKey() ? 79 : 97);
        return result;
    }
}

