/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.util.List;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import nl.sidnlabs.dnslib.types.TypeMap;

public class NSECTypeDecoder {
    public void decode(int octetAvailable, NetworkData buffer, List<TypeMap> types) {
        if (octetAvailable > 0) {
            int octetsRead = 0;
            while (octetsRead < octetAvailable) {
                short blockCount = buffer.readUnsignedByte();
                int blockLength = buffer.readUnsignedByte();
                octetsRead += 2;
                for (int i = 0; i < blockLength; ++i) {
                    short flags = buffer.readUnsignedByte();
                    ++octetsRead;
                    int flag = 0;
                    if ((flags & 0x80) == 128) {
                        flag = i * 8 + 0;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 0x40) == 64) {
                        flag = i * 8 + 1;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 0x20) == 32) {
                        flag = i * 8 + 2;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 0x10) == 16) {
                        flag = i * 8 + 3;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 8) == 8) {
                        flag = i * 8 + 4;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 4) == 4) {
                        flag = i * 8 + 5;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 2) == 2) {
                        flag = i * 8 + 6;
                        this.createRRtype(flag, blockCount, types);
                    }
                    if ((flags & 1) != 1) continue;
                    flag = i * 8 + 7;
                    this.createRRtype(flag, blockCount, types);
                }
            }
        }
    }

    private void createRRtype(int flag, short blockCount, List<TypeMap> types) {
        if (flag > 0) {
            ResourceRecordType rrType = ResourceRecordType.fromValue((char)(flag += blockCount * 256));
            if (rrType == null) {
                rrType = ResourceRecordType.RESERVED;
            }
            types.add(new TypeMap(rrType, (char)flag));
        }
    }
}

