/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.edns0;

import java.net.InetAddress;
import java.net.UnknownHostException;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.edns0.EDNS0Option;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class ClientSubnetOption
extends EDNS0Option {
    private int fam;
    private int sourcenetmask;
    private int scopenetmask;
    private String address;
    private InetAddress inetAddress;

    public ClientSubnetOption() {
    }

    public ClientSubnetOption(int code, int len, NetworkData buffer) {
        super(code, len, buffer);
    }

    public String export() {
        return (this.fam == 1 ? "4," : "6,") + this.address + "/" + this.sourcenetmask + "," + this.scopenetmask;
    }

    public boolean isIPv4() {
        return this.fam == 1;
    }

    @Override
    public void decode(NetworkData buffer) {
        this.fam = buffer.readUnsignedChar();
        this.sourcenetmask = buffer.readUnsignedByte();
        this.scopenetmask = buffer.readUnsignedByte();
        int addrLength = this.len - 4;
        if (addrLength > 0) {
            byte[] addrBytes = new byte[]{};
            if (this.fam == 1) {
                addrBytes = buffer.readBytes(4, Math.min(4, addrLength));
            } else if (this.fam == 2) {
                addrBytes = buffer.readBytes(16, Math.min(16, addrLength));
            }
            try {
                this.inetAddress = InetAddress.getByAddress(addrBytes);
            }
            catch (UnknownHostException e) {
                throw new DnsDecodeException("Invalid IP address", e);
            }
            this.address = this.inetAddress.getHostAddress();
        }
    }

    public int getFam() {
        return this.fam;
    }

    public int getSourcenetmask() {
        return this.sourcenetmask;
    }

    public int getScopenetmask() {
        return this.scopenetmask;
    }

    public String getAddress() {
        return this.address;
    }

    public InetAddress getInetAddress() {
        return this.inetAddress;
    }

    public void setFam(int fam) {
        this.fam = fam;
    }

    public void setSourcenetmask(int sourcenetmask) {
        this.sourcenetmask = sourcenetmask;
    }

    public void setScopenetmask(int scopenetmask) {
        this.scopenetmask = scopenetmask;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setInetAddress(InetAddress inetAddress) {
        this.inetAddress = inetAddress;
    }

    @Override
    public String toString() {
        return "ClientSubnetOption(fam=" + this.getFam() + ", sourcenetmask=" + this.getSourcenetmask() + ", scopenetmask=" + this.getScopenetmask() + ", address=" + this.getAddress() + ", inetAddress=" + this.getInetAddress() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSubnetOption)) {
            return false;
        }
        ClientSubnetOption other = (ClientSubnetOption)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getFam() != other.getFam()) {
            return false;
        }
        if (this.getSourcenetmask() != other.getSourcenetmask()) {
            return false;
        }
        if (this.getScopenetmask() != other.getScopenetmask()) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        InetAddress this$inetAddress = this.getInetAddress();
        InetAddress other$inetAddress = other.getInetAddress();
        return !(this$inetAddress == null ? other$inetAddress != null : !((Object)this$inetAddress).equals(other$inetAddress));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClientSubnetOption;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getFam();
        result = result * 59 + this.getSourcenetmask();
        result = result * 59 + this.getScopenetmask();
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        InetAddress $inetAddress = this.getInetAddress();
        result = result * 59 + ($inetAddress == null ? 43 : ((Object)$inetAddress).hashCode());
        return result;
    }
}

