/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.edns0;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.records.edns0.ClientSubnetOption;
import nl.sidnlabs.dnslib.message.records.edns0.DNSSECOption;
import nl.sidnlabs.dnslib.message.records.edns0.EDNS0Option;
import nl.sidnlabs.dnslib.message.records.edns0.KeyTagOption;
import nl.sidnlabs.dnslib.message.records.edns0.NSidOption;
import nl.sidnlabs.dnslib.message.records.edns0.PaddingOption;
import nl.sidnlabs.dnslib.message.records.edns0.PingOption;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OPTResourceRecord
extends AbstractResourceRecord {
    private static final Logger log = LogManager.getLogger(OPTResourceRecord.class);
    private static final long serialVersionUID = 1L;
    private static final char DNSSEC_DO_BIT_MASK = '\u8000';
    private static final int POWERDNS_EDNSPING_UDPSIZE = 1200;
    private static final int POWERDNS_EDNSPING_LENGTH = 4;
    private char udpPlayloadSize = (char)4096;
    private char rdLeng = '\u0000';
    private short rcode;
    private short version;
    private char flags;
    private boolean dnssecDo;
    private List<EDNS0Option> options = new ArrayList<EDNS0Option>();

    public OPTResourceRecord() {
        this.name = ".";
        this.type = ResourceRecordType.OPT;
    }

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        this.name = DNSStringUtil.readName(buffer);
        char type = buffer.readUnsignedChar();
        this.setType(ResourceRecordType.fromValue(type));
        this.udpPlayloadSize = buffer.readUnsignedChar();
        this.rcode = buffer.readUnsignedByte();
        this.version = buffer.readUnsignedByte();
        this.flags = buffer.readUnsignedChar();
        this.dnssecDo = (this.flags & 0x8000) == 32768;
        this.rdLeng = buffer.readUnsignedChar();
        if (this.rdLeng > '\u0000') {
            try {
                this.loadOptions(buffer);
            }
            catch (Exception e) {
                log.error("Could not decode OPT RR", (Throwable)e);
            }
        }
    }

    private void loadOptions(NetworkData buffer) {
        if (this.rdLeng > buffer.bytesAvailable()) {
            log.error("Incorrect edns rdata size, rdlength=" + this.rdLeng + " and bytesavail:" + buffer.bytesAvailable());
            return;
        }
        byte[] optionBytes = new byte[this.rdLeng];
        buffer.readBytes(optionBytes);
        NetworkData opt = new NetworkData(optionBytes);
        while (opt.isBytesAvailable()) {
            EDNS0Option option = this.decodeOption(opt);
            this.options.add(option);
        }
    }

    private EDNS0Option decodeOption(NetworkData opt) {
        char optioncode = opt.readUnsignedChar();
        char optionlen = opt.readUnsignedChar();
        if (optioncode == '\u0003') {
            return new NSidOption(optioncode, optionlen, opt);
        }
        if (optioncode == '\u0005') {
            if (this.udpPlayloadSize == '\u04b0' && optionlen == '\u0004') {
                return new PingOption(optioncode, optionlen, opt);
            }
            return new DNSSECOption(optioncode, optionlen, opt);
        }
        if (optioncode == '\u0006' || optioncode == '\u0007') {
            return new DNSSECOption(optioncode, optionlen, opt);
        }
        if (optioncode == '\b') {
            return new ClientSubnetOption(optioncode, optionlen, opt);
        }
        if (optioncode == '\f') {
            return new PaddingOption(optioncode, optionlen, opt);
        }
        if (optioncode == '\u000e') {
            return new KeyTagOption(optioncode, optionlen, opt);
        }
        return new EDNS0Option(optioncode, optionlen, opt);
    }

    @Override
    public void encode(NetworkData buffer) {
        log.debug("encode");
        buffer.writeByte(0);
        buffer.writeChar(this.type.getValue());
        buffer.writeChar(this.udpPlayloadSize);
        buffer.writeByte(0);
        buffer.writeByte(0);
        int flags = 0;
        flags = (char)(flags | 0x8000);
        buffer.writeChar(flags);
        buffer.writeChar(this.rdLeng);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        return builder.add("name", this.name).add("type", this.type.name()).add("payload-size", (int)this.udpPlayloadSize).add("rcode", (int)this.rcode).add("flags", (int)this.flags).add("rdata", Json.createObjectBuilder().add("do", this.dnssecDo)).build();
    }

    @Override
    public String toZone(int maxLength) {
        return "";
    }

    public char getUdpPlayloadSize() {
        return this.udpPlayloadSize;
    }

    public char getRdLeng() {
        return this.rdLeng;
    }

    public short getRcode() {
        return this.rcode;
    }

    public short getVersion() {
        return this.version;
    }

    public char getFlags() {
        return this.flags;
    }

    public boolean isDnssecDo() {
        return this.dnssecDo;
    }

    public List<EDNS0Option> getOptions() {
        return this.options;
    }

    public void setUdpPlayloadSize(char udpPlayloadSize) {
        this.udpPlayloadSize = udpPlayloadSize;
    }

    public void setRdLeng(char rdLeng) {
        this.rdLeng = rdLeng;
    }

    public void setRcode(short rcode) {
        this.rcode = rcode;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public void setFlags(char flags) {
        this.flags = flags;
    }

    public void setDnssecDo(boolean dnssecDo) {
        this.dnssecDo = dnssecDo;
    }

    public void setOptions(List<EDNS0Option> options) {
        this.options = options;
    }

    @Override
    public String toString() {
        return "OPTResourceRecord(udpPlayloadSize=" + this.getUdpPlayloadSize() + ", rdLeng=" + this.getRdLeng() + ", rcode=" + this.getRcode() + ", version=" + this.getVersion() + ", flags=" + this.getFlags() + ", dnssecDo=" + this.isDnssecDo() + ", options=" + this.getOptions() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OPTResourceRecord)) {
            return false;
        }
        OPTResourceRecord other = (OPTResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getUdpPlayloadSize() != other.getUdpPlayloadSize()) {
            return false;
        }
        if (this.getRdLeng() != other.getRdLeng()) {
            return false;
        }
        if (this.getRcode() != other.getRcode()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.isDnssecDo() != other.isDnssecDo()) {
            return false;
        }
        List<EDNS0Option> this$options = this.getOptions();
        List<EDNS0Option> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OPTResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getUdpPlayloadSize();
        result = result * 59 + this.getRdLeng();
        result = result * 59 + this.getRcode();
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getFlags();
        result = result * 59 + (this.isDnssecDo() ? 79 : 97);
        List<EDNS0Option> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }
}

