/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import nl.sidnlabs.dnslib.exception.DnsEncodeException;

public class NetworkData {
    private byte[] buf;
    private int index = 0;
    private int markedIndex = 0;
    private ByteArrayOutputStream backing;
    private DataOutput writeBuffer;
    private int writerIndex;

    public NetworkData(int size) {
        this.backing = new ByteArrayOutputStream(size);
        this.writeBuffer = new DataOutputStream(this.backing);
    }

    public NetworkData() {
        this(4096);
    }

    public NetworkData(byte[] data) {
        this.buf = data;
        this.index = 0;
    }

    public int length() {
        return this.buf.length;
    }

    public int bytesAvailable() {
        return this.buf.length - this.index;
    }

    public boolean isBytesAvailable() {
        return this.index < this.buf.length - 1;
    }

    public long readUnsignedInt() {
        int byte1 = 0xFF & this.buf[this.index];
        int byte2 = 0xFF & this.buf[this.index + 1];
        int byte3 = 0xFF & this.buf[this.index + 2];
        int byte4 = 0xFF & this.buf[this.index + 3];
        this.index += 4;
        return (long)(byte1 << 24 | byte2 << 16 | byte3 << 8 | byte4) & 0xFFFFFFFFL;
    }

    public short readUnsignedByte() {
        int byte1 = 0xFF & this.buf[this.index];
        ++this.index;
        return (short)byte1;
    }

    public char readUnsignedChar() {
        int byte1 = 0xFF & this.buf[this.index];
        int byte2 = 0xFF & this.buf[this.index + 1];
        this.index += 2;
        return (char)(byte1 << 8 | byte2);
    }

    public byte[] readBytes() {
        byte[] destination = new byte[this.buf.length - this.index];
        System.arraycopy(this.buf, this.index, destination, 0, destination.length);
        this.index += destination.length;
        return destination;
    }

    public void readBytes(byte[] destination) {
        System.arraycopy(this.buf, this.index, destination, 0, destination.length);
        this.index += destination.length;
    }

    public byte[] readBytes(int len, int max) {
        byte[] destination = new byte[len];
        System.arraycopy(this.buf, this.index, destination, 0, max);
        this.index += max;
        return destination;
    }

    public void writeChar(int c) {
        try {
            this.writeBuffer.writeChar(c);
            this.writerIndex += 2;
        }
        catch (IOException e) {
            throw new DnsEncodeException("Error while writing char", e);
        }
    }

    public void writeByte(int b) {
        try {
            this.writeBuffer.write(b);
            ++this.writerIndex;
        }
        catch (IOException e) {
            throw new DnsEncodeException("Error while writing byte", e);
        }
    }

    public void writeBytes(byte[] b) {
        try {
            this.writeBuffer.write(b);
            this.writerIndex += b.length;
        }
        catch (IOException e) {
            throw new DnsEncodeException("Error while writing byte[]", e);
        }
    }

    public void writeInt(long i) {
        try {
            this.writeBuffer.writeInt((int)i);
            this.writerIndex += 4;
        }
        catch (IOException e) {
            throw new DnsEncodeException("Error while writing int", e);
        }
    }

    public byte[] write() {
        byte[] data = this.backing.toByteArray();
        return Arrays.copyOf(data, this.writerIndex);
    }

    public int readableBytes() {
        if (this.buf != null) {
            return this.buf.length;
        }
        return 0;
    }

    public int writableBytes() {
        return this.writerIndex;
    }

    public int getReaderIndex() {
        return this.index;
    }

    public void setReaderIndex(int index) {
        this.index = index;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public void markReaderIndex() {
        this.markedIndex = this.index;
    }

    public void resetReaderIndex() {
        this.index = this.markedIndex;
    }

    public void rewind(int bytes) {
        this.index -= bytes;
    }

    public byte[] getBytes() {
        return this.buf;
    }
}

