/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import nl.sidnlabs.dnslib.util.Domaininfo;
import nl.sidnlabs.dnslib.util.InternetDomainName;
import org.apache.commons.lang3.StringUtils;

public class NameUtil {
    private NameUtil() {
    }

    public static Domaininfo getDomain(String name) {
        if (name == null || name.length() == 0) {
            return new Domaininfo(null, 0);
        }
        if (StringUtils.equals((CharSequence)name, (CharSequence)".")) {
            return new Domaininfo(name, 0);
        }
        try {
            InternetDomainName domainname = InternetDomainName.from(name);
            if (domainname.isRegistrySuffix()) {
                return new Domaininfo(domainname.registrySuffix().toString(), domainname.parts().size());
            }
            if (domainname.isUnderRegistrySuffix()) {
                return new Domaininfo(domainname.topDomainUnderRegistrySuffix().toString(), domainname.parts().size());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Domaininfo(null, StringUtils.split((String)StringUtils.removeEnd((String)name, (String)"."), (String)".").length);
    }
}

