/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import nl.sidnlabs.dnslib.message.Header;
import nl.sidnlabs.dnslib.message.Question;
import nl.sidnlabs.dnslib.message.RRset;
import nl.sidnlabs.dnslib.message.records.ResourceRecord;
import nl.sidnlabs.dnslib.message.records.ResourceRecordFactory;
import nl.sidnlabs.dnslib.message.records.edns0.OPTResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.OpcodeType;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Message {
    private static final Logger log = LogManager.getLogger(Message.class);
    private boolean partial;
    private boolean allowFail;
    private int bytes;
    private Header header;
    private List<Question> questions;
    private List<RRset> answer;
    private List<RRset> authority;
    private List<RRset> additional;
    private OPTResourceRecord pseudo;

    public Message() {
        this.questions = new ArrayList<Question>();
        this.answer = new ArrayList<RRset>();
        this.authority = new ArrayList<RRset>();
        this.additional = new ArrayList<RRset>();
    }

    public Message(NetworkData data) {
        this(data, false, false);
    }

    public Message(NetworkData data, boolean partial, boolean allowFail) {
        block3: {
            this.questions = new ArrayList<Question>();
            this.answer = new ArrayList<RRset>();
            this.authority = new ArrayList<RRset>();
            this.additional = new ArrayList<RRset>();
            this.bytes = data.length();
            this.partial = partial;
            this.allowFail = allowFail;
            try {
                this.decode(data);
                if (log.isTraceEnabled()) {
                    String qname = this.questions.isEmpty() ? "" : this.questions.get(0).getQName();
                    log.trace("Decoded DNS message type: {} and qname: {}", (Object)this.header.getQr(), (Object)qname);
                }
            }
            catch (Exception e) {
                if (allowFail) break block3;
                throw e;
            }
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Message addQuestion(Question question) {
        this.questions.add(question);
        return this;
    }

    private RRset findRRset(List<RRset> setList, ResourceRecord rr) {
        for (RRset rrset : setList) {
            if (!rrset.getOwner().equalsIgnoreCase(rr.getName()) || rrset.getClassz() != rr.getClassz() || rrset.getType() != rr.getType()) continue;
            return rrset;
        }
        return null;
    }

    private RRset createRRset(List<RRset> setList, ResourceRecord rr) {
        RRset rrset = RRset.createAs(rr);
        setList.add(rrset);
        return rrset;
    }

    public void addAnswer(ResourceRecord answer) {
        RRset rrset = this.findRRset(this.answer, answer);
        if (rrset == null) {
            rrset = this.createRRset(this.answer, answer);
        } else {
            rrset.add(answer);
        }
    }

    public void addAnswer(RRset rrset) {
        this.answer.add(rrset);
    }

    public void addAuthority(ResourceRecord authority) {
        RRset rrset = this.findRRset(this.authority, authority);
        if (rrset == null) {
            rrset = this.createRRset(this.authority, authority);
        } else {
            rrset.add(authority);
        }
    }

    public void addAuthority(RRset authority) {
        this.authority.add(authority);
    }

    public List<RRset> getAdditional() {
        return this.additional;
    }

    public void addAdditional(ResourceRecord rr) {
        RRset rrset = this.findRRset(this.additional, rr);
        if (rrset == null) {
            rrset = this.createRRset(this.additional, rr);
        } else {
            rrset.add(rr);
        }
    }

    public void addAdditional(RRset additional) {
        if (additional.getType() != ResourceRecordType.OPT) {
            this.additional.add(additional);
        }
    }

    public void decode(NetworkData buffer) {
        ResourceRecord rr;
        int i;
        this.header = new Header();
        this.header.decode(buffer);
        if (this.header.getOpCode() != OpcodeType.STANDARD) {
            if (log.isDebugEnabled()) {
                log.debug("Unsupported OPCODE {}, do not continue to decode messsage past header", (Object)this.header.getOpCode());
            }
            return;
        }
        for (i = 0; i < this.header.getQdCount(); ++i) {
            Question question = this.decodeQuestion(buffer);
            this.addQuestion(question);
        }
        for (i = 0; i < this.header.getAnCount(); ++i) {
            rr = this.decodeResourceRecord(buffer);
            if (this.partial) continue;
            this.addAnswer(rr);
        }
        for (i = 0; i < this.header.getNsCount(); ++i) {
            rr = this.decodeResourceRecord(buffer);
            if (this.partial) continue;
            this.addAuthority(rr);
        }
        for (i = 0; i < this.header.getArCount(); ++i) {
            rr = this.decodeResourceRecord(buffer);
            if (rr != null && rr.getType() != ResourceRecordType.OPT) {
                if (this.partial) continue;
                this.addAdditional(rr);
                continue;
            }
            this.pseudo = (OPTResourceRecord)rr;
        }
    }

    private ResourceRecord decodeResourceRecord(NetworkData buffer) {
        buffer.markReaderIndex();
        DNSStringUtil.readNameUsingBuffer(buffer);
        char type = buffer.readUnsignedChar();
        buffer.resetReaderIndex();
        ResourceRecord rr = ResourceRecordFactory.getInstance().createResourceRecord(type);
        if (this.partial) {
            if (rr.getType() == ResourceRecordType.OPT) {
                rr.decode(buffer, this.partial);
            }
            return rr;
        }
        rr.decode(buffer, this.partial);
        return rr;
    }

    private Question decodeQuestion(NetworkData buffer) {
        Question question = new Question();
        question.decode(buffer);
        return question;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nheader\n");
        builder.append("_______________________________________________\n");
        builder.append("Message [header=" + this.header + "] ");
        builder.append("\n");
        builder.append("question\n");
        builder.append("_______________________________________________\n");
        for (Question question : this.questions) {
            builder.append(question.toString());
            builder.append("\n");
        }
        builder.append("answer\n");
        builder.append("_______________________________________________\n");
        for (RRset rrset : this.answer) {
            builder.append(rrset.toString());
            builder.append("\n");
        }
        builder.append("authority\n");
        builder.append("_______________________________________________\n");
        for (RRset rrset : this.authority) {
            builder.append(rrset.toString());
            builder.append("\n");
        }
        builder.append("additional\n");
        builder.append("_______________________________________________\n");
        for (RRset rrset : this.additional) {
            builder.append(rrset.toString());
            builder.append("\n");
        }
        return builder.toString();
    }

    public Object toZone() {
        StringBuilder builder = new StringBuilder();
        builder.append("; header: " + this.header.toZone() + "\n");
        int maxLength = this.maxLength();
        builder.append("; answer section:\n");
        for (RRset rrset : this.answer) {
            builder.append(rrset.toZone(maxLength));
        }
        builder.append("; authority section:\n");
        for (RRset rrset : this.authority) {
            builder.append(rrset.toZone(maxLength));
        }
        builder.append("; additional section:\n");
        for (RRset rrset : this.additional) {
            builder.append(rrset.toZone(maxLength));
        }
        return builder.toString();
    }

    public JsonObject toJson() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("header", (JsonValue)this.header.toJSon());
        JsonArrayBuilder questionsBuilder = Json.createArrayBuilder();
        for (Question question : this.questions) {
            questionsBuilder.add((JsonValue)question.toJSon());
        }
        builder.add("question", (JsonValue)questionsBuilder.build());
        JsonArrayBuilder rrBuilder = Json.createArrayBuilder();
        for (RRset rrset : this.answer) {
            rrBuilder.add((JsonValue)rrset.toJSon());
        }
        builder.add("answer", (JsonValue)rrBuilder.build());
        rrBuilder = Json.createArrayBuilder();
        for (RRset rrset : this.authority) {
            rrBuilder.add((JsonValue)rrset.toJSon());
        }
        builder.add("authority", (JsonValue)rrBuilder.build());
        rrBuilder = Json.createArrayBuilder();
        for (RRset rrset : this.additional) {
            rrBuilder.add((JsonValue)rrset.toJSon());
        }
        builder.add("additional", (JsonValue)rrBuilder.build());
        return builder.build();
    }

    public int maxLength() {
        int length = 0;
        for (RRset rrset : this.answer) {
            if (rrset.getOwner().length() <= length) continue;
            length = rrset.getOwner().length();
        }
        for (RRset rrset : this.authority) {
            if (rrset.getOwner().length() <= length) continue;
            length = rrset.getOwner().length();
        }
        for (RRset rrset : this.additional) {
            if (rrset.getOwner().length() <= length) continue;
            length = rrset.getOwner().length();
        }
        return length;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean isAllowFail() {
        return this.allowFail;
    }

    public int getBytes() {
        return this.bytes;
    }

    public List<Question> getQuestions() {
        return this.questions;
    }

    public List<RRset> getAnswer() {
        return this.answer;
    }

    public List<RRset> getAuthority() {
        return this.authority;
    }

    public OPTResourceRecord getPseudo() {
        return this.pseudo;
    }

    public void setPartial(boolean partial) {
        this.partial = partial;
    }

    public void setAllowFail(boolean allowFail) {
        this.allowFail = allowFail;
    }

    public void setBytes(int bytes) {
        this.bytes = bytes;
    }

    public void setHeader(Header header) {
        this.header = header;
    }

    public void setQuestions(List<Question> questions) {
        this.questions = questions;
    }

    public void setAnswer(List<RRset> answer) {
        this.answer = answer;
    }

    public void setAuthority(List<RRset> authority) {
        this.authority = authority;
    }

    public void setAdditional(List<RRset> additional) {
        this.additional = additional;
    }

    public void setPseudo(OPTResourceRecord pseudo) {
        this.pseudo = pseudo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPartial() != other.isPartial()) {
            return false;
        }
        if (this.isAllowFail() != other.isAllowFail()) {
            return false;
        }
        if (this.getBytes() != other.getBytes()) {
            return false;
        }
        Header this$header = this.getHeader();
        Header other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        List<Question> this$questions = this.getQuestions();
        List<Question> other$questions = other.getQuestions();
        if (this$questions == null ? other$questions != null : !((Object)this$questions).equals(other$questions)) {
            return false;
        }
        List<RRset> this$answer = this.getAnswer();
        List<RRset> other$answer = other.getAnswer();
        if (this$answer == null ? other$answer != null : !((Object)this$answer).equals(other$answer)) {
            return false;
        }
        List<RRset> this$authority = this.getAuthority();
        List<RRset> other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !((Object)this$authority).equals(other$authority)) {
            return false;
        }
        List<RRset> this$additional = this.getAdditional();
        List<RRset> other$additional = other.getAdditional();
        if (this$additional == null ? other$additional != null : !((Object)this$additional).equals(other$additional)) {
            return false;
        }
        OPTResourceRecord this$pseudo = this.getPseudo();
        OPTResourceRecord other$pseudo = other.getPseudo();
        return !(this$pseudo == null ? other$pseudo != null : !((Object)this$pseudo).equals(other$pseudo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPartial() ? 79 : 97);
        result = result * 59 + (this.isAllowFail() ? 79 : 97);
        result = result * 59 + this.getBytes();
        Header $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        List<Question> $questions = this.getQuestions();
        result = result * 59 + ($questions == null ? 43 : ((Object)$questions).hashCode());
        List<RRset> $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : ((Object)$answer).hashCode());
        List<RRset> $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : ((Object)$authority).hashCode());
        List<RRset> $additional = this.getAdditional();
        result = result * 59 + ($additional == null ? 43 : ((Object)$additional).hashCode());
        OPTResourceRecord $pseudo = this.getPseudo();
        result = result * 59 + ($pseudo == null ? 43 : ((Object)$pseudo).hashCode());
        return result;
    }
}

