/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message;

import javax.json.Json;
import javax.json.JsonObject;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.ResourceRecordClass;
import nl.sidnlabs.dnslib.types.ResourceRecordType;
import org.apache.commons.lang3.StringUtils;

public class Question {
    private String qName;
    private ResourceRecordType qType;
    private int qTypeValue;
    private ResourceRecordClass qClass;
    private int qClassValue;

    public Question() {
    }

    public Question(String qName, ResourceRecordType qType, ResourceRecordClass qClass) {
        this.qName = qName;
        this.qType = qType;
        this.qClass = qClass;
    }

    public void decode(NetworkData buffer) {
        String qname = DNSStringUtil.readNameUsingBuffer(buffer);
        this.setQName(qname != null ? StringUtils.lowerCase((String)qname) : "");
        this.qTypeValue = buffer.readUnsignedChar();
        this.setQType(ResourceRecordType.fromValue(this.qTypeValue));
        this.qClassValue = buffer.readUnsignedChar();
        this.setQClass(ResourceRecordClass.fromValue(this.qClassValue));
    }

    public JsonObject toJSon() {
        return Json.createObjectBuilder().add("qName", this.qName).add("qType", this.qType != null ? this.qType.name() : "").add("qClass", this.qClass != null ? this.qClass.name() : "").build();
    }

    public String getQName() {
        return this.qName;
    }

    public ResourceRecordType getQType() {
        return this.qType;
    }

    public int getQTypeValue() {
        return this.qTypeValue;
    }

    public ResourceRecordClass getQClass() {
        return this.qClass;
    }

    public int getQClassValue() {
        return this.qClassValue;
    }

    public void setQName(String qName) {
        this.qName = qName;
    }

    public void setQType(ResourceRecordType qType) {
        this.qType = qType;
    }

    public void setQTypeValue(int qTypeValue) {
        this.qTypeValue = qTypeValue;
    }

    public void setQClass(ResourceRecordClass qClass) {
        this.qClass = qClass;
    }

    public void setQClassValue(int qClassValue) {
        this.qClassValue = qClassValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Question)) {
            return false;
        }
        Question other = (Question)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getQTypeValue() != other.getQTypeValue()) {
            return false;
        }
        if (this.getQClassValue() != other.getQClassValue()) {
            return false;
        }
        String this$qName = this.getQName();
        String other$qName = other.getQName();
        if (this$qName == null ? other$qName != null : !this$qName.equals(other$qName)) {
            return false;
        }
        ResourceRecordType this$qType = this.getQType();
        ResourceRecordType other$qType = other.getQType();
        if (this$qType == null ? other$qType != null : !((Object)((Object)this$qType)).equals((Object)other$qType)) {
            return false;
        }
        ResourceRecordClass this$qClass = this.getQClass();
        ResourceRecordClass other$qClass = other.getQClass();
        return !(this$qClass == null ? other$qClass != null : !((Object)((Object)this$qClass)).equals((Object)other$qClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Question;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getQTypeValue();
        result = result * 59 + this.getQClassValue();
        String $qName = this.getQName();
        result = result * 59 + ($qName == null ? 43 : $qName.hashCode());
        ResourceRecordType $qType = this.getQType();
        result = result * 59 + ($qType == null ? 43 : ((Object)((Object)$qType)).hashCode());
        ResourceRecordClass $qClass = this.getQClass();
        result = result * 59 + ($qClass == null ? 43 : ((Object)((Object)$qClass)).hashCode());
        return result;
    }

    public String toString() {
        return "Question(qName=" + this.getQName() + ", qType=" + this.getQType() + ", qTypeValue=" + this.getQTypeValue() + ", qClass=" + this.getQClass() + ", qClassValue=" + this.getQClassValue() + ")";
    }
}

