/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class CNAMEResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = -1067442440297409161L;
    private String cname;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.cname = DNSStringUtil.readNameUsingBuffer(buffer);
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.cname.length() + 2);
        DNSStringUtil.writeName(this.cname, buffer);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.cname;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("cname", this.cname)).build();
    }

    public String getCname() {
        return this.cname;
    }

    public void setCname(String cname) {
        this.cname = cname;
    }

    @Override
    public String toString() {
        return "CNAMEResourceRecord(cname=" + this.getCname() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CNAMEResourceRecord)) {
            return false;
        }
        CNAMEResourceRecord other = (CNAMEResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$cname = this.getCname();
        String other$cname = other.getCname();
        return !(this$cname == null ? other$cname != null : !this$cname.equals(other$cname));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CNAMEResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $cname = this.getCname();
        result = result * 59 + ($cname == null ? 43 : $cname.hashCode());
        return result;
    }
}

