/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.exception.DnsDecodeException;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class LOCResourceRecord
extends AbstractResourceRecord {
    private static NumberFormat w2 = new DecimalFormat();
    private static NumberFormat w3;
    private static final long serialVersionUID = 1L;
    private short version;
    private short size;
    private short sizeBase;
    private short sizePower;
    private short horizontalPrecision;
    private short verticalPrecision;
    private long latitude;
    private long longitude;
    private long altitude;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.version = buffer.readUnsignedByte();
            if (this.version != 0) {
                throw new DnsDecodeException("LOCResourceRecord Illegal version number: " + this.version);
            }
            this.size = buffer.readUnsignedByte();
            this.sizeBase = (short)((this.size & 0xF0) >>> 4);
            this.sizePower = (short)(this.size & 0xF);
            this.horizontalPrecision = buffer.readUnsignedByte();
            this.verticalPrecision = buffer.readUnsignedByte();
            this.latitude = buffer.readUnsignedInt();
            this.longitude = buffer.readUnsignedInt();
            this.altitude = buffer.readUnsignedInt();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeByte(this.version);
        buffer.writeByte(this.size);
        buffer.writeByte(this.horizontalPrecision);
        buffer.writeByte(this.verticalPrecision);
        buffer.writeInt(this.latitude);
        buffer.writeInt(this.longitude);
        buffer.writeInt(this.altitude);
    }

    @Override
    public String toZone(int maxLength) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toZone(maxLength) + "\t");
        sb.append(this.positionToString(this.latitude, 'N', 'S'));
        sb.append(" ");
        sb.append(this.positionToString(this.longitude, 'E', 'W'));
        sb.append(" ");
        this.renderFixedPoint(sb, w2, this.altitude - 10000000L, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.size, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.horizontalPrecision, 100L);
        sb.append("m ");
        this.renderFixedPoint(sb, w2, this.verticalPrecision, 100L);
        sb.append("m");
        return sb.toString();
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("version", (int)this.version).add("size", (int)this.size).add("hor_pre", (int)this.horizontalPrecision).add("vert_pre", (int)this.verticalPrecision).add("lat", this.latitude).add("long", this.longitude).add("alt", this.altitude)).build();
    }

    private String positionToString(long value, char pos, char neg) {
        char direction;
        StringBuilder sb = new StringBuilder();
        long temp = value - 0x80000000L;
        if (temp < 0L) {
            temp = -temp;
            direction = neg;
        } else {
            direction = pos;
        }
        sb.append(temp / 3600000L);
        sb.append(" ");
        sb.append((temp %= 3600000L) / 60000L);
        sb.append(" ");
        this.renderFixedPoint(sb, w3, temp %= 60000L, 1000L);
        sb.append(" ");
        sb.append(direction);
        return sb.toString();
    }

    private void renderFixedPoint(StringBuilder sb, NumberFormat formatter, long value, long divisor) {
        sb.append(value / divisor);
        if ((value %= divisor) != 0L) {
            sb.append(".");
            sb.append(formatter.format(value));
        }
    }

    public short getVersion() {
        return this.version;
    }

    public short getSize() {
        return this.size;
    }

    public short getSizeBase() {
        return this.sizeBase;
    }

    public short getSizePower() {
        return this.sizePower;
    }

    public short getHorizontalPrecision() {
        return this.horizontalPrecision;
    }

    public short getVerticalPrecision() {
        return this.verticalPrecision;
    }

    public long getLatitude() {
        return this.latitude;
    }

    public long getLongitude() {
        return this.longitude;
    }

    public long getAltitude() {
        return this.altitude;
    }

    public void setVersion(short version) {
        this.version = version;
    }

    public void setSize(short size) {
        this.size = size;
    }

    public void setSizeBase(short sizeBase) {
        this.sizeBase = sizeBase;
    }

    public void setSizePower(short sizePower) {
        this.sizePower = sizePower;
    }

    public void setHorizontalPrecision(short horizontalPrecision) {
        this.horizontalPrecision = horizontalPrecision;
    }

    public void setVerticalPrecision(short verticalPrecision) {
        this.verticalPrecision = verticalPrecision;
    }

    public void setLatitude(long latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(long longitude) {
        this.longitude = longitude;
    }

    public void setAltitude(long altitude) {
        this.altitude = altitude;
    }

    @Override
    public String toString() {
        return "LOCResourceRecord(version=" + this.getVersion() + ", size=" + this.getSize() + ", sizeBase=" + this.getSizeBase() + ", sizePower=" + this.getSizePower() + ", horizontalPrecision=" + this.getHorizontalPrecision() + ", verticalPrecision=" + this.getVerticalPrecision() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", altitude=" + this.getAltitude() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LOCResourceRecord)) {
            return false;
        }
        LOCResourceRecord other = (LOCResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getSizeBase() != other.getSizeBase()) {
            return false;
        }
        if (this.getSizePower() != other.getSizePower()) {
            return false;
        }
        if (this.getHorizontalPrecision() != other.getHorizontalPrecision()) {
            return false;
        }
        if (this.getVerticalPrecision() != other.getVerticalPrecision()) {
            return false;
        }
        if (this.getLatitude() != other.getLatitude()) {
            return false;
        }
        if (this.getLongitude() != other.getLongitude()) {
            return false;
        }
        return this.getAltitude() == other.getAltitude();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LOCResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getVersion();
        result = result * 59 + this.getSize();
        result = result * 59 + this.getSizeBase();
        result = result * 59 + this.getSizePower();
        result = result * 59 + this.getHorizontalPrecision();
        result = result * 59 + this.getVerticalPrecision();
        long $latitude = this.getLatitude();
        result = result * 59 + (int)($latitude >>> 32 ^ $latitude);
        long $longitude = this.getLongitude();
        result = result * 59 + (int)($longitude >>> 32 ^ $longitude);
        long $altitude = this.getAltitude();
        result = result * 59 + (int)($altitude >>> 32 ^ $altitude);
        return result;
    }

    static {
        w2.setMinimumIntegerDigits(2);
        w3 = new DecimalFormat();
        w3.setMinimumIntegerDigits(3);
    }
}

