/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.DNSStringUtil;
import nl.sidnlabs.dnslib.message.util.NetworkData;

public class SOAResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = -5562024832624364745L;
    private String mName;
    private String rName;
    private long serial;
    private long refresh;
    private long retry;
    private long expire;
    private long minimum;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.mName = DNSStringUtil.readNameUsingBuffer(buffer);
            this.rName = DNSStringUtil.readNameUsingBuffer(buffer);
            this.serial = buffer.readUnsignedInt();
            this.refresh = buffer.readUnsignedInt();
            this.retry = buffer.readUnsignedInt();
            this.expire = buffer.readUnsignedInt();
            this.minimum = buffer.readUnsignedInt();
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        char rdLength = (char)(this.mName.length() + 2 + (this.rName.length() + 2) + 20);
        buffer.writeChar(rdLength);
        DNSStringUtil.writeName(this.mName, buffer);
        DNSStringUtil.writeName(this.rName, buffer);
        buffer.writeInt((int)this.serial);
        buffer.writeInt((int)this.refresh);
        buffer.writeInt((int)this.retry);
        buffer.writeInt((int)this.expire);
        buffer.writeInt((int)this.minimum);
    }

    @Override
    public String toZone(int maxLength) {
        return super.toZone(maxLength) + "\t" + this.mName + " " + this.rName + " " + this.serial + " " + this.refresh + " " + this.retry + " " + this.expire + " " + this.minimum;
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("mname", this.mName).add("rname", this.rName).add("serial", this.serial).add("refresh", this.refresh).add("retry", this.retry).add("expire", this.expire).add("minimum", this.minimum)).build();
    }

    public String getMName() {
        return this.mName;
    }

    public String getRName() {
        return this.rName;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getRefresh() {
        return this.refresh;
    }

    public long getRetry() {
        return this.retry;
    }

    public long getExpire() {
        return this.expire;
    }

    public long getMinimum() {
        return this.minimum;
    }

    public void setMName(String mName) {
        this.mName = mName;
    }

    public void setRName(String rName) {
        this.rName = rName;
    }

    public void setSerial(long serial) {
        this.serial = serial;
    }

    public void setRefresh(long refresh) {
        this.refresh = refresh;
    }

    public void setRetry(long retry) {
        this.retry = retry;
    }

    public void setExpire(long expire) {
        this.expire = expire;
    }

    public void setMinimum(long minimum) {
        this.minimum = minimum;
    }

    @Override
    public String toString() {
        return "SOAResourceRecord(mName=" + this.getMName() + ", rName=" + this.getRName() + ", serial=" + this.getSerial() + ", refresh=" + this.getRefresh() + ", retry=" + this.getRetry() + ", expire=" + this.getExpire() + ", minimum=" + this.getMinimum() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SOAResourceRecord)) {
            return false;
        }
        SOAResourceRecord other = (SOAResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getSerial() != other.getSerial()) {
            return false;
        }
        if (this.getRefresh() != other.getRefresh()) {
            return false;
        }
        if (this.getRetry() != other.getRetry()) {
            return false;
        }
        if (this.getExpire() != other.getExpire()) {
            return false;
        }
        if (this.getMinimum() != other.getMinimum()) {
            return false;
        }
        String this$mName = this.getMName();
        String other$mName = other.getMName();
        if (this$mName == null ? other$mName != null : !this$mName.equals(other$mName)) {
            return false;
        }
        String this$rName = this.getRName();
        String other$rName = other.getRName();
        return !(this$rName == null ? other$rName != null : !this$rName.equals(other$rName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SOAResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $serial = this.getSerial();
        result = result * 59 + (int)($serial >>> 32 ^ $serial);
        long $refresh = this.getRefresh();
        result = result * 59 + (int)($refresh >>> 32 ^ $refresh);
        long $retry = this.getRetry();
        result = result * 59 + (int)($retry >>> 32 ^ $retry);
        long $expire = this.getExpire();
        result = result * 59 + (int)($expire >>> 32 ^ $expire);
        long $minimum = this.getMinimum();
        result = result * 59 + (int)($minimum >>> 32 ^ $minimum);
        String $mName = this.getMName();
        result = result * 59 + ($mName == null ? 43 : $mName.hashCode());
        String $rName = this.getRName();
        result = result * 59 + ($rName == null ? 43 : $rName.hashCode());
        return result;
    }
}

