/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records.dnssec;

import java.util.Arrays;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import nl.sidnlabs.dnslib.message.records.AbstractResourceRecord;
import nl.sidnlabs.dnslib.message.util.NetworkData;
import nl.sidnlabs.dnslib.types.AlgorithmType;
import nl.sidnlabs.dnslib.types.DigestType;
import org.apache.commons.codec.binary.Hex;

public class DSResourceRecord
extends AbstractResourceRecord {
    private static final long serialVersionUID = 1L;
    private char keytag;
    private AlgorithmType algorithm;
    private DigestType digestType;
    private byte[] digest;
    private String hex;

    @Override
    public void decode(NetworkData buffer, boolean partial) {
        super.decode(buffer, partial);
        if (!partial) {
            this.keytag = buffer.readUnsignedChar();
            short alg = buffer.readUnsignedByte();
            this.algorithm = AlgorithmType.fromValue(alg);
            short dt = buffer.readUnsignedByte();
            this.digestType = DigestType.fromValue(dt);
            this.digest = new byte[this.rdLength - 4];
            buffer.readBytes(this.digest);
            this.hex = new String(Hex.encodeHex((byte[])this.digest));
        }
    }

    @Override
    public void encode(NetworkData buffer) {
        super.encode(buffer);
        buffer.writeChar(this.rdLength);
        buffer.writeChar(this.keytag);
        buffer.writeByte(this.algorithm.getValue());
        buffer.writeByte(this.digestType.getValue());
        buffer.writeBytes(this.digest);
    }

    @Override
    public JsonObject toJSon() {
        JsonObjectBuilder builder = super.createJsonBuilder();
        return builder.add("rdata", Json.createObjectBuilder().add("keytag", (int)this.keytag).add("algorithm", this.algorithm != null ? this.algorithm.name() : "").add("digest-type", this.digestType.name()).add("digest", this.hex)).build();
    }

    public char getKeytag() {
        return this.keytag;
    }

    public AlgorithmType getAlgorithm() {
        return this.algorithm;
    }

    public DigestType getDigestType() {
        return this.digestType;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public String getHex() {
        return this.hex;
    }

    public void setKeytag(char keytag) {
        this.keytag = keytag;
    }

    public void setAlgorithm(AlgorithmType algorithm) {
        this.algorithm = algorithm;
    }

    public void setDigestType(DigestType digestType) {
        this.digestType = digestType;
    }

    public void setDigest(byte[] digest) {
        this.digest = digest;
    }

    public void setHex(String hex) {
        this.hex = hex;
    }

    @Override
    public String toString() {
        return "DSResourceRecord(keytag=" + this.getKeytag() + ", algorithm=" + this.getAlgorithm() + ", digestType=" + this.getDigestType() + ", digest=" + Arrays.toString(this.getDigest()) + ", hex=" + this.getHex() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DSResourceRecord)) {
            return false;
        }
        DSResourceRecord other = (DSResourceRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getKeytag() != other.getKeytag()) {
            return false;
        }
        AlgorithmType this$algorithm = this.getAlgorithm();
        AlgorithmType other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        DigestType this$digestType = this.getDigestType();
        DigestType other$digestType = other.getDigestType();
        if (this$digestType == null ? other$digestType != null : !((Object)((Object)this$digestType)).equals((Object)other$digestType)) {
            return false;
        }
        if (!Arrays.equals(this.getDigest(), other.getDigest())) {
            return false;
        }
        String this$hex = this.getHex();
        String other$hex = other.getHex();
        return !(this$hex == null ? other$hex != null : !this$hex.equals(other$hex));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DSResourceRecord;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getKeytag();
        AlgorithmType $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        DigestType $digestType = this.getDigestType();
        result = result * 59 + ($digestType == null ? 43 : ((Object)((Object)$digestType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getDigest());
        String $hex = this.getHex();
        result = result * 59 + ($hex == null ? 43 : $hex.hashCode());
        return result;
    }
}

