/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.util;

import nl.sidnlabs.dnslib.util.Domaininfo;
import nl.sidnlabs.dnslib.util.InternetDomainName;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NameUtil {
    private static final Logger log = LogManager.getLogger(NameUtil.class);

    private NameUtil() {
    }

    public static Domaininfo getDomain(String name) {
        return NameUtil.getDomain(name, false);
    }

    public static Domaininfo getDomain(String name, boolean allowInvalid) {
        block6: {
            if (name == null || name.length() == 0) {
                return new Domaininfo(null, 0);
            }
            if (StringUtils.equals((CharSequence)name, (CharSequence)".")) {
                return new Domaininfo(name, 0);
            }
            try {
                InternetDomainName domainname = InternetDomainName.from(name, allowInvalid);
                if (domainname.isRegistrySuffix()) {
                    return new Domaininfo(domainname.registrySuffix().toString(), domainname.parts().size());
                }
                if (domainname.isUnderRegistrySuffix()) {
                    return new Domaininfo(domainname.topDomainUnderRegistrySuffix().toString(), domainname.parts().size());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug("InternetDomainName error", (Throwable)e);
            }
        }
        return new Domaininfo(null, StringUtils.split((String)StringUtils.removeEnd((String)name, (String)"."), (String)".").length);
    }
}

