/*
 * Decompiled with CFR 0.152.
 */
package nl.sidnlabs.dnslib.message.records;

import nl.sidnlabs.dnslib.message.records.AAAAResourceRecord;
import nl.sidnlabs.dnslib.message.records.AResourceRecord;
import nl.sidnlabs.dnslib.message.records.AnyResourceRecord;
import nl.sidnlabs.dnslib.message.records.CNAMEResourceRecord;
import nl.sidnlabs.dnslib.message.records.HINFOResourceRecord;
import nl.sidnlabs.dnslib.message.records.LOCResourceRecord;
import nl.sidnlabs.dnslib.message.records.MXResourceRecord;
import nl.sidnlabs.dnslib.message.records.NAPTRResourceRecord;
import nl.sidnlabs.dnslib.message.records.NSResourceRecord;
import nl.sidnlabs.dnslib.message.records.NotImplementedResourceRecord;
import nl.sidnlabs.dnslib.message.records.PTRResourceRecord;
import nl.sidnlabs.dnslib.message.records.ResourceRecord;
import nl.sidnlabs.dnslib.message.records.SOAResourceRecord;
import nl.sidnlabs.dnslib.message.records.SPFResourceRecord;
import nl.sidnlabs.dnslib.message.records.SRVResourceRecord;
import nl.sidnlabs.dnslib.message.records.SSHFPResourceRecord;
import nl.sidnlabs.dnslib.message.records.TSIGResourceRecord;
import nl.sidnlabs.dnslib.message.records.TXTResourceRecord;
import nl.sidnlabs.dnslib.message.records.URIResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.DNSKEYResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.DSResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.NSEC3ParamResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.NSEC3ResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.NSECResourceRecord;
import nl.sidnlabs.dnslib.message.records.dnssec.RRSIGResourceRecord;
import nl.sidnlabs.dnslib.message.records.edns0.OPTResourceRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceRecordFactory {
    private static final Logger log = LogManager.getLogger(ResourceRecordFactory.class);
    private static ResourceRecordFactory instance = new ResourceRecordFactory();

    private ResourceRecordFactory() {
    }

    public static ResourceRecordFactory getInstance() {
        return instance;
    }

    public ResourceRecord createResourceRecord(int type) {
        switch (type) {
            case 1: {
                return new AResourceRecord();
            }
            case 2: {
                return new NSResourceRecord();
            }
            case 28: {
                return new AAAAResourceRecord();
            }
            case 5: {
                return new CNAMEResourceRecord();
            }
            case 6: {
                return new SOAResourceRecord();
            }
            case 12: {
                return new PTRResourceRecord();
            }
            case 13: {
                return new HINFOResourceRecord();
            }
            case 15: {
                return new MXResourceRecord();
            }
            case 16: {
                return new TXTResourceRecord();
            }
            case 29: {
                return new LOCResourceRecord();
            }
            case 33: {
                return new SRVResourceRecord();
            }
            case 35: {
                return new NAPTRResourceRecord();
            }
            case 41: {
                return new OPTResourceRecord();
            }
            case 43: {
                return new DSResourceRecord();
            }
            case 44: {
                return new SSHFPResourceRecord();
            }
            case 46: {
                return new RRSIGResourceRecord();
            }
            case 47: {
                return new NSECResourceRecord();
            }
            case 48: {
                return new DNSKEYResourceRecord();
            }
            case 50: {
                return new NSEC3ResourceRecord();
            }
            case 51: {
                return new NSEC3ParamResourceRecord();
            }
            case 99: {
                return new SPFResourceRecord();
            }
            case 250: {
                return new TSIGResourceRecord();
            }
            case 255: {
                return new AnyResourceRecord();
            }
            case 256: {
                return new URIResourceRecord();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Unknown RR with type " + type);
        }
        return new NotImplementedResourceRecord();
    }
}

